/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.loader.ldif;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.EntityFactory;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.LdapSyntax;
import org.apache.directory.shared.ldap.schema.LoadableSchemaObject;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.schema.loader.ldif.AttributeClassLoader;
import org.apache.directory.shared.ldap.schema.parsers.LdapComparatorDescription;
import org.apache.directory.shared.ldap.schema.parsers.NormalizerDescription;
import org.apache.directory.shared.ldap.schema.parsers.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.schema.registries.DefaultSchema;
import org.apache.directory.shared.ldap.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.registries.Schema;
import org.apache.directory.shared.ldap.util.Base64;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaEntityFactory
implements EntityFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaEntityFactory.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static final Class<?>[] parameterTypes = new Class[]{Registries.class};
    private static final List<String> EMPTY_LIST = new ArrayList<String>();
    private static final String[] EMPTY_ARRAY = new String[0];
    private final AttributeClassLoader classLoader = new AttributeClassLoader();

    private String getOid(Entry entry, String objectType) throws LdapInvalidAttributeValueException {
        EntryAttribute mOid = entry.get("m-oid");
        if (mOid == null) {
            String msg = I18n.err((String)"ERR_10005", (Object[])new Object[]{objectType, "m-oid"});
            LOG.warn(msg);
            throw new NullPointerException(msg);
        }
        String oid = mOid.getString();
        if (!OID.isOID((String)oid)) {
            String msg = I18n.err((String)"ERR_10006", (Object[])new Object[]{oid});
            LOG.warn(msg);
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg);
        }
        return oid;
    }

    private String getOid(SchemaObject description, String objectType) throws LdapInvalidAttributeValueException {
        String oid = description.getOid();
        if (oid == null) {
            String msg = I18n.err((String)"ERR_10005", (Object[])new Object[]{objectType, "m-oid"});
            LOG.warn(msg);
            throw new NullPointerException(msg);
        }
        if (!OID.isOID((String)oid)) {
            String msg = I18n.err((String)"ERR_10006", (Object[])new Object[]{oid});
            LOG.warn(msg);
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg);
        }
        return oid;
    }

    private void checkEntry(Entry entry, String schemaEntity) {
        if (entry == null) {
            String msg = I18n.err((String)"ERR_10007", (Object[])new Object[]{schemaEntity});
            LOG.warn(msg);
            throw new NullPointerException(msg);
        }
    }

    private void checkDescription(SchemaObject description, String schemaEntity) {
        if (description == null) {
            String msg = I18n.err((String)"ERR_10008", (Object[])new Object[]{schemaEntity});
            LOG.warn(msg);
            throw new NullPointerException(msg);
        }
    }

    private Schema getSchema(String schemaName, Registries registries) {
        Schema schema;
        if (StringTools.isEmpty((String)schemaName)) {
            schemaName = "other";
        }
        if ((schema = registries.getLoadedSchema(schemaName)) == null) {
            String msg = I18n.err((String)"ERR_10009", (Object[])new Object[]{schemaName});
            LOG.error(msg);
        }
        return schema;
    }

    public Schema getSchema(Entry entry) throws Exception {
        String[] dependencies = EMPTY_ARRAY;
        boolean isDisabled = false;
        if (entry == null) {
            throw new NullPointerException(I18n.err((String)"ERR_10010", (Object[])new Object[0]));
        }
        if (entry.get("cn") == null) {
            throw new NullPointerException(I18n.err((String)"ERR_10011", (Object[])new Object[0]));
        }
        String name = entry.get("cn").getString();
        if (entry.get("creatorsName") == null) {
            throw new NullPointerException(I18n.err((String)"ERR_10012", (Object[])new Object[]{"creatorsName"}));
        }
        String owner = entry.get("creatorsName").getString();
        if (entry.get("m-disabled") != null) {
            String value = entry.get("m-disabled").getString();
            value = value.toUpperCase();
            isDisabled = value.equals("TRUE");
        }
        if (entry.get("m-dependencies") != null) {
            HashSet<String> depsSet = new HashSet<String>();
            EntryAttribute depsAttr = entry.get("m-dependencies");
            for (Value value : depsAttr) {
                depsSet.add(value.getString());
            }
            dependencies = depsSet.toArray(EMPTY_ARRAY);
        }
        return new DefaultSchema(name, owner, dependencies, isDisabled);
    }

    private SyntaxChecker classLoadSyntaxChecker(SchemaManager schemaManager, String oid, String className, EntryAttribute byteCode, Registries targetRegistries) throws Exception {
        Class<?> clazz = null;
        SyntaxChecker syntaxChecker = null;
        String byteCodeStr = "";
        if (byteCode == null) {
            clazz = Class.forName(className);
        } else {
            this.classLoader.setAttribute(byteCode);
            clazz = this.classLoader.loadClass(className);
            byteCodeStr = new String(Base64.encode((byte[])byteCode.getBytes()));
        }
        syntaxChecker = (SyntaxChecker)clazz.newInstance();
        syntaxChecker.setBytecode(byteCodeStr);
        syntaxChecker.setFqcn(className);
        syntaxChecker.setOid(oid);
        return syntaxChecker;
    }

    public SyntaxChecker getSyntaxChecker(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws Exception {
        this.checkEntry(entry, "SyntaxChecker");
        String oid = this.getOid(entry, "SyntaxChecker");
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err((String)"ERR_10013", (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((String)"ERR_10014", (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        String className = this.getFqcn(entry, "SyntaxChecker");
        EntryAttribute byteCode = entry.get("m-bytecode");
        SyntaxChecker syntaxChecker = this.classLoadSyntaxChecker(schemaManager, oid, className, byteCode, targetRegistries);
        this.setSchemaObjectProperties((SchemaObject)syntaxChecker, entry, schema);
        return syntaxChecker;
    }

    public SyntaxChecker getSyntaxChecker(SchemaManager schemaManager, SyntaxCheckerDescription syntaxCheckerDescription, Registries targetRegistries, String schemaName) throws Exception {
        this.checkDescription((SchemaObject)syntaxCheckerDescription, "SyntaxChecker");
        String oid = this.getOid((SchemaObject)syntaxCheckerDescription, "SyntaxChecker");
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((String)"ERR_10013", (Object[])new Object[]{syntaxCheckerDescription.getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        String fqcn = this.getFqcn((LoadableSchemaObject)syntaxCheckerDescription, "SyntaxChecker");
        EntryAttribute byteCode = this.getByteCode((LoadableSchemaObject)syntaxCheckerDescription, "SyntaxChecker");
        SyntaxChecker syntaxChecker = this.classLoadSyntaxChecker(schemaManager, oid, fqcn, byteCode, targetRegistries);
        this.setSchemaObjectProperties((SchemaObject)syntaxChecker, (SchemaObject)syntaxCheckerDescription, schema);
        return syntaxChecker;
    }

    private LdapComparator<?> classLoadComparator(SchemaManager schemaManager, String oid, String className, EntryAttribute byteCode, Registries targetRegistries) throws Exception {
        String byteCodeStr;
        LdapComparator comparator;
        block4: {
            comparator = null;
            Class<?> clazz = null;
            byteCodeStr = "";
            if (byteCode == null) {
                clazz = Class.forName(className);
            } else {
                this.classLoader.setAttribute(byteCode);
                clazz = this.classLoader.loadClass(className);
                byteCodeStr = new String(Base64.encode((byte[])byteCode.getBytes()));
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(String.class);
                comparator = (LdapComparator)constructor.newInstance(oid);
            }
            catch (NoSuchMethodException nsme) {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                comparator = (LdapComparator)clazz.newInstance();
                if (comparator.getOid().equals(oid)) break block4;
                String msg = I18n.err((String)"ERR_10015", (Object[])new Object[]{oid, comparator.getOid()});
                throw new LdapInvalidAttributeValueException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
            }
        }
        comparator.setBytecode(byteCodeStr);
        comparator.setFqcn(className);
        comparator.setSchemaManager(schemaManager);
        return comparator;
    }

    public LdapComparator<?> getLdapComparator(SchemaManager schemaManager, LdapComparatorDescription comparatorDescription, Registries targetRegistries, String schemaName) throws Exception {
        this.checkDescription((SchemaObject)comparatorDescription, "Comparator");
        String oid = this.getOid((SchemaObject)comparatorDescription, "Comparator");
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((String)"ERR_10016", (Object[])new Object[]{comparatorDescription.getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        String fqcn = this.getFqcn((LoadableSchemaObject)comparatorDescription, "Comparator");
        EntryAttribute byteCode = this.getByteCode((LoadableSchemaObject)comparatorDescription, "Comparator");
        LdapComparator<?> comparator = this.classLoadComparator(schemaManager, oid, fqcn, byteCode, targetRegistries);
        this.setSchemaObjectProperties((SchemaObject)comparator, (SchemaObject)comparatorDescription, schema);
        return comparator;
    }

    public LdapComparator<?> getLdapComparator(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws Exception {
        this.checkEntry(entry, "Comparator");
        String oid = this.getOid(entry, "Comparator");
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err((String)"ERR_10016", (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((String)"ERR_10017", (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        String fqcn = this.getFqcn(entry, "Comparator");
        EntryAttribute byteCode = entry.get("m-bytecode");
        LdapComparator<?> comparator = this.classLoadComparator(schemaManager, oid, fqcn, byteCode, targetRegistries);
        this.setSchemaObjectProperties((SchemaObject)comparator, entry, schema);
        return comparator;
    }

    private Normalizer classLoadNormalizer(SchemaManager schemaManager, String oid, String className, EntryAttribute byteCode, Registries targetRegistries) throws Exception {
        Class<?> clazz = null;
        Normalizer normalizer = null;
        String byteCodeStr = "";
        if (byteCode == null) {
            clazz = Class.forName(className);
        } else {
            this.classLoader.setAttribute(byteCode);
            clazz = this.classLoader.loadClass(className);
            byteCodeStr = new String(Base64.encode((byte[])byteCode.getBytes()));
        }
        normalizer = (Normalizer)clazz.newInstance();
        normalizer.setBytecode(byteCodeStr);
        normalizer.setFqcn(className);
        normalizer.setOid(oid);
        normalizer.setSchemaManager(schemaManager);
        return normalizer;
    }

    public Normalizer getNormalizer(SchemaManager schemaManager, NormalizerDescription normalizerDescription, Registries targetRegistries, String schemaName) throws Exception {
        this.checkDescription((SchemaObject)normalizerDescription, "Normalizer");
        String oid = this.getOid((SchemaObject)normalizerDescription, "Normalizer");
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((String)"ERR_10018", (Object[])new Object[]{normalizerDescription.getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        String fqcn = this.getFqcn((LoadableSchemaObject)normalizerDescription, "Normalizer");
        EntryAttribute byteCode = this.getByteCode((LoadableSchemaObject)normalizerDescription, "Normalizer");
        Normalizer normalizer = this.classLoadNormalizer(schemaManager, oid, fqcn, byteCode, targetRegistries);
        this.setSchemaObjectProperties((SchemaObject)normalizer, (SchemaObject)normalizerDescription, schema);
        return normalizer;
    }

    public Normalizer getNormalizer(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws Exception {
        this.checkEntry(entry, "Normalizer");
        String oid = this.getOid(entry, "Normalizer");
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err((String)"ERR_10018", (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((String)"ERR_10019", (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        String className = this.getFqcn(entry, "Normalizer");
        EntryAttribute byteCode = entry.get("m-bytecode");
        Normalizer normalizer = this.classLoadNormalizer(schemaManager, oid, className, byteCode, targetRegistries);
        this.setSchemaObjectProperties((SchemaObject)normalizer, entry, schema);
        return normalizer;
    }

    private void injectRegistries(Object obj, Registries targetRegistries) throws Exception {
        Method method = null;
        try {
            method = obj.getClass().getMethod("setRegistries", parameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (IS_DEBUG) {
                LOG.debug(obj.getClass() + " has no setRegistries() method.");
            }
            return;
        }
        if (method == null) {
            return;
        }
        Object[] args = new Object[]{targetRegistries};
        method.invoke(obj, args);
    }

    public LdapSyntax getSyntax(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws LdapInvalidAttributeValueException, LdapUnwillingToPerformException {
        this.checkEntry(entry, "Syntax");
        String oid = this.getOid(entry, "Syntax");
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err((String)"ERR_10020", (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((String)"ERR_10021", (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        LdapSyntax syntax = new LdapSyntax(oid);
        EntryAttribute mHumanReadable = entry.get("x-humanReadable");
        if (mHumanReadable != null) {
            String val = mHumanReadable.getString();
            syntax.setHumanReadable(val.toUpperCase().equals("TRUE"));
        }
        this.setSchemaObjectProperties((SchemaObject)syntax, entry, schema);
        return syntax;
    }

    public MatchingRule getMatchingRule(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws LdapUnwillingToPerformException, LdapInvalidAttributeValueException {
        this.checkEntry(entry, "MatchingRule");
        String oid = this.getOid(entry, "MatchingRule");
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err((String)"ERR_10022", (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((String)"ERR_10023", (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        MatchingRule matchingRule = new MatchingRule(oid);
        EntryAttribute mSyntax = entry.get("m-syntax");
        if (mSyntax != null) {
            matchingRule.setSyntaxOid(mSyntax.getString());
        }
        this.setSchemaObjectProperties((SchemaObject)matchingRule, entry, schema);
        return matchingRule;
    }

    private List<String> getStrings(EntryAttribute attr) {
        if (attr == null) {
            return EMPTY_LIST;
        }
        ArrayList<String> strings = new ArrayList<String>(attr.size());
        for (Value value : attr) {
            strings.add(value.getString());
        }
        return strings;
    }

    public ObjectClass getObjectClass(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws Exception {
        EntryAttribute mTypeObjectClass;
        EntryAttribute mMust;
        EntryAttribute mMay;
        this.checkEntry(entry, "ObjectCLass");
        String oid = this.getOid(entry, "ObjectCLass");
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err((String)"ERR_10024", (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((String)"ERR_10025", (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        ObjectClass oc = new ObjectClass(oid);
        EntryAttribute mSuperiors = entry.get("m-supObjectClass");
        if (mSuperiors != null) {
            oc.setSuperiorOids(this.getStrings(mSuperiors));
        }
        if ((mMay = entry.get("m-may")) != null) {
            oc.setMayAttributeTypeOids(this.getStrings(mMay));
        }
        if ((mMust = entry.get("m-must")) != null) {
            oc.setMustAttributeTypeOids(this.getStrings(mMust));
        }
        if ((mTypeObjectClass = entry.get("m-typeObjectClass")) != null) {
            String type = mTypeObjectClass.getString();
            oc.setType(ObjectClassTypeEnum.getClassType((String)type));
        }
        this.setSchemaObjectProperties((SchemaObject)oc, entry, schema);
        return oc;
    }

    public AttributeType getAttributeType(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws LdapInvalidAttributeValueException, LdapUnwillingToPerformException {
        EntryAttribute mUsage;
        EntryAttribute mNoUserModification;
        EntryAttribute mSingleValued;
        EntryAttribute mCollective;
        EntryAttribute mSupAttributeType;
        EntryAttribute mSubstr;
        EntryAttribute mOrdering;
        EntryAttribute mEquality;
        EntryAttribute mSyntaxLength;
        this.checkEntry(entry, "AttributeType");
        String oid = this.getOid(entry, "AttributeType");
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err((String)"ERR_10026", (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((String)"ERR_10027", (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        AttributeType attributeType = new AttributeType(oid);
        EntryAttribute mSyntax = entry.get("m-syntax");
        if (mSyntax != null && mSyntax.get() != null) {
            attributeType.setSyntaxOid(mSyntax.getString());
        }
        if ((mSyntaxLength = entry.get("m-length")) != null) {
            attributeType.setSyntaxLength(Integer.parseInt(mSyntaxLength.getString()));
        }
        if ((mEquality = entry.get("m-equality")) != null) {
            attributeType.setEqualityOid(mEquality.getString());
        }
        if ((mOrdering = entry.get("m-ordering")) != null) {
            attributeType.setOrderingOid(mOrdering.getString());
        }
        if ((mSubstr = entry.get("m-substr")) != null) {
            attributeType.setSubstringOid(mSubstr.getString());
        }
        if ((mSupAttributeType = entry.get("m-supAttributeType")) != null) {
            attributeType.setSuperiorOid(mSupAttributeType.getString());
        }
        if ((mCollective = entry.get("m-collective")) != null) {
            String val = mCollective.getString();
            attributeType.setCollective(val.equalsIgnoreCase("TRUE"));
        }
        if ((mSingleValued = entry.get("m-singleValue")) != null) {
            String val = mSingleValued.getString();
            attributeType.setSingleValued(val.equalsIgnoreCase("TRUE"));
        }
        if ((mNoUserModification = entry.get("m-noUserModification")) != null) {
            String val = mNoUserModification.getString();
            attributeType.setUserModifiable(!val.equalsIgnoreCase("TRUE"));
        }
        if ((mUsage = entry.get("m-usage")) != null) {
            attributeType.setUsage(UsageEnum.getUsage((String)mUsage.getString()));
        }
        this.setSchemaObjectProperties((SchemaObject)attributeType, entry, schema);
        return attributeType;
    }

    private String getFqcn(Entry entry, String objectType) throws LdapInvalidAttributeValueException {
        EntryAttribute mFqcn = entry.get("m-fqcn");
        if (mFqcn == null) {
            String msg = I18n.err((String)"ERR_10028", (Object[])new Object[]{objectType, "m-fqcn"});
            LOG.warn(msg);
            throw new NullPointerException(msg);
        }
        return mFqcn.getString();
    }

    private String getFqcn(LoadableSchemaObject description, String objectType) {
        String mFqcn = description.getFqcn();
        if (mFqcn == null) {
            String msg = I18n.err((String)"ERR_10028", (Object[])new Object[]{objectType, "m-fqcn"});
            LOG.warn(msg);
            throw new NullPointerException(msg);
        }
        return mFqcn;
    }

    private EntryAttribute getByteCode(Entry entry, String objectType) {
        EntryAttribute byteCode = entry.get("m-bytecode");
        if (byteCode == null) {
            String msg = I18n.err((String)"ERR_10028", (Object[])new Object[]{objectType, "m-bytecode"});
            LOG.warn(msg);
            throw new NullPointerException(msg);
        }
        return byteCode;
    }

    private EntryAttribute getByteCode(LoadableSchemaObject description, String objectType) {
        String byteCodeString = description.getBytecode();
        if (byteCodeString == null) {
            String msg = I18n.err((String)"ERR_10028", (Object[])new Object[]{objectType, "m-bytecode"});
            LOG.warn(msg);
            throw new NullPointerException(msg);
        }
        byte[] bytecode = Base64.decode((char[])byteCodeString.toCharArray());
        DefaultClientAttribute attr = new DefaultClientAttribute("m-bytecode", (byte[][])new byte[][]{bytecode});
        return attr;
    }

    private void setSchemaObjectProperties(SchemaObject schemaObject, Entry entry, Schema schema) throws LdapInvalidAttributeValueException {
        EntryAttribute mDisabled;
        EntryAttribute names;
        EntryAttribute mDescription;
        EntryAttribute mObsolete = entry.get("m-obsolete");
        if (mObsolete != null) {
            String val = mObsolete.getString();
            schemaObject.setObsolete(val.equalsIgnoreCase("TRUE"));
        }
        if ((mDescription = entry.get("m-description")) != null) {
            schemaObject.setDescription(mDescription.getString());
        }
        if ((names = entry.get("m-name")) != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (Value name : names) {
                values.add(name.getString());
            }
            schemaObject.setNames(values);
        }
        if ((mDisabled = entry.get("m-disabled")) != null) {
            String val = mDisabled.getString();
            schemaObject.setEnabled(!val.equalsIgnoreCase("TRUE"));
        } else {
            schemaObject.setEnabled(schema != null && schema.isEnabled());
        }
        EntryAttribute mIsReadOnly = entry.get("m-noUserModification");
        if (mIsReadOnly != null) {
            String val = mIsReadOnly.getString();
            schemaObject.setReadOnly(val.equalsIgnoreCase("TRUE"));
        }
        schemaObject.setSchemaName(schema.getSchemaName());
    }

    private void setSchemaObjectProperties(SchemaObject schemaObject, SchemaObject description, Schema schema) {
        schemaObject.setObsolete(description.isObsolete());
        schemaObject.setDescription(description.getDescription());
        schemaObject.setNames(description.getNames());
        schemaObject.setEnabled(schema.isEnabled());
        schemaObject.setReadOnly(false);
        schemaObject.setSpecification(description.getSpecification());
        schemaObject.setSchemaName(schema.getSchemaName());
        schemaObject.setExtensions(description.getExtensions());
    }
}

