/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schemaloader;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeClassLoader
extends ClassLoader {
    private Attribute attribute;

    public AttributeClassLoader() {
        super(AttributeClassLoader.class.getClassLoader());
    }

    public void setAttribute(Attribute attribute) throws LdapException {
        if (attribute.isHumanReadable()) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.CONSTRAINT_VIOLATION, I18n.err((I18n)I18n.ERR_10001, (Object[])new Object[0]));
        }
        this.attribute = attribute;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = null;
        Value value = this.attribute.get();
        if (value.isHumanReadable()) {
            throw new ClassNotFoundException(I18n.err((I18n)I18n.ERR_10002, (Object[])new Object[0]));
        }
        classBytes = value.getBytes();
        return this.defineClass(name, classBytes, 0, classBytes.length);
    }
}

