/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.syntaxCheckers;

import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchScopeSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(SearchScopeSyntaxChecker.class);

    public SearchScopeSyntaxChecker() {
        super("1.3.6.1.4.1.18060.0.4.1.0.10");
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        strValue = Strings.trim((String)Strings.toLowerCase((String)strValue));
        return "base".equals(strValue) || "one".equals(strValue) || "sub".equals(strValue);
    }
}

