/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended.ads_impl;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.util.Strings;

public class CertGenerationObject
extends AbstractAsn1Object {
    private String targetDN;
    private String issuerDN;
    private String subjectDN;
    private String keyAlgorithm;
    private int requestLength = 0;

    public int computeLength() {
        int len = Strings.getBytesUtf8((String)this.targetDN).length;
        this.requestLength = 1 + Value.getNbBytes((int)len) + len;
        len = Strings.getBytesUtf8((String)this.issuerDN).length;
        this.requestLength += 1 + Value.getNbBytes((int)len) + len;
        len = Strings.getBytesUtf8((String)this.subjectDN).length;
        this.requestLength += 1 + Value.getNbBytes((int)len) + len;
        len = Strings.getBytesUtf8((String)this.keyAlgorithm).length;
        this.requestLength += 1 + Value.getNbBytes((int)len) + len;
        return 1 + Value.getNbBytes((int)this.requestLength) + this.requestLength;
    }

    public ByteBuffer encode() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(Value.getBytes((int)this.requestLength));
        Value.encode((ByteBuffer)bb, (String)this.targetDN);
        Value.encode((ByteBuffer)bb, (String)this.issuerDN);
        Value.encode((ByteBuffer)bb, (String)this.subjectDN);
        Value.encode((ByteBuffer)bb, (String)this.keyAlgorithm);
        return bb;
    }

    public String getTargetDN() {
        return this.targetDN;
    }

    public void setTargetDN(String targetDN) {
        this.targetDN = targetDN;
    }

    public String getIssuerDN() {
        return this.issuerDN;
    }

    public void setIssuerDN(String issuerDN) {
        this.issuerDN = issuerDN;
    }

    public String getSubjectDN() {
        return this.subjectDN;
    }

    public void setSubjectDN(String subjectDN) {
        this.subjectDN = subjectDN;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Certficate Generation Object { ").append(" Target Dn: ").append(this.targetDN).append(',');
        sb.append(" Issuer Dn: ").append(this.issuerDN).append(',');
        sb.append(" Subject Dn: ").append(this.subjectDN).append(',');
        sb.append(" Key Algorithm: ").append(this.keyAlgorithm).append(" }");
        return sb.toString();
    }
}

