/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.message.ModifyResponseImpl;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;

public class ModifyNoDResponse
extends ModifyResponseImpl {
    public static final String EXTENSION_OID = "1.3.6.1.4.1.1466.20036";
    private static final byte[] EMPTY_RESPONSE = new byte[0];
    public static final ModifyNoDResponse UNAVAILABLE = new ModifyNoDResponse(ResultCodeEnum.UNAVAILABLE);
    public static final ModifyNoDResponse PROTOCOLERROR = new ModifyNoDResponse(ResultCodeEnum.PROTOCOL_ERROR);
    public static final ModifyNoDResponse STRONGAUTHREQUIRED = new ModifyNoDResponse(ResultCodeEnum.STRONG_AUTH_REQUIRED);

    private ModifyNoDResponse(ResultCodeEnum rcode) {
        switch (rcode) {
            case UNAVAILABLE: {
                break;
            }
            case PROTOCOL_ERROR: {
                break;
            }
            case STRONG_AUTH_REQUIRED: {
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04166, (Object[])new Object[]{ResultCodeEnum.UNAVAILABLE, ResultCodeEnum.PROTOCOL_ERROR, ResultCodeEnum.STRONG_AUTH_REQUIRED}));
            }
        }
        super.getLdapResult().setErrorMessage(rcode.toString() + ": The server will disconnect!");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
    }

    public byte[] getResponse() {
        return EMPTY_RESPONSE;
    }

    public String getResponseName() {
        return EXTENSION_OID;
    }
}

