/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended;

import javax.naming.NamingException;
import javax.naming.ldap.ExtendedResponse;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.extras.extended.GracefulShutdownResponse;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulShutdown;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulShutdownDecoder;
import org.apache.directory.shared.ldap.model.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.model.message.ResultResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulShutdownRequest
extends ExtendedRequestImpl {
    private static final Logger LOG = LoggerFactory.getLogger(GracefulShutdownRequest.class);
    private static final long serialVersionUID = -4682291068700593492L;
    public static final String EXTENSION_OID = "1.3.6.1.4.1.18060.0.1.3";
    public static final int UNDETERMINED = 0;
    public static final int NOW = 0;
    private int timeOffline;
    private int delay;

    public GracefulShutdownRequest(int messageId) {
        this(messageId, 0, 0);
    }

    public GracefulShutdownRequest(int messageId, int timeOffline, int delay) {
        super(messageId);
        this.setRequestName(EXTENSION_OID);
        this.timeOffline = timeOffline;
        this.delay = delay;
    }

    public void setRequestValue(byte[] requestValue) {
        GracefulShutdownDecoder decoder = new GracefulShutdownDecoder();
        try {
            GracefulShutdown gs = (GracefulShutdown)decoder.decode(requestValue);
            if (requestValue != null) {
                this.requestValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.requestValue, 0, requestValue.length);
            } else {
                this.requestValue = null;
            }
            this.timeOffline = gs.getTimeOffline();
            this.delay = gs.getDelay();
        }
        catch (DecoderException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_04165, (Object[])new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        return (ExtendedResponse)this.getResultResponse();
    }

    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                GracefulShutdown gs = new GracefulShutdown();
                gs.setDelay(this.delay);
                gs.setTimeOffline(this.timeOffline);
                this.requestValue = gs.encode().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_04164, (Object[])new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.requestValue;
    }

    public ResultResponse getResultResponse() {
        if (this.response == null) {
            GracefulShutdownResponse gsr = new GracefulShutdownResponse(this.getMessageId());
            this.response = gsr;
        }
        return this.response;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getTimeOffline() {
        return this.timeOffline;
    }

    public void setTimeOffline(int timeOffline) {
        this.timeOffline = timeOffline;
    }
}

