/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulDisconnectContainer;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulDisconnectDecoder;
import org.apache.directory.shared.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.shared.ldap.model.filter.LdapURL;
import org.apache.directory.shared.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.model.message.Referral;
import org.apache.directory.shared.ldap.model.message.ReferralImpl;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulDisconnect
extends ExtendedResponseImpl {
    private static final long serialVersionUID = -4682291068700593492L;
    public static final String EXTENSION_OID = "1.3.6.1.4.1.18060.0.1.5";
    private static final Logger LOG = LoggerFactory.getLogger(GracefulDisconnect.class);
    private int timeOffline;
    private int delay;
    private Referral replicatedContexts = new ReferralImpl();

    public GracefulDisconnect(byte[] responseValue) throws DecoderException {
        super(0, EXTENSION_OID);
        if (responseValue != null) {
            this.responseValue = new byte[responseValue.length];
            System.arraycopy(responseValue, 0, this.responseValue, 0, responseValue.length);
        } else {
            this.responseValue = null;
        }
        this.decodeValue();
    }

    public GracefulDisconnect(int timeOffline, int delay) {
        super(0, EXTENSION_OID);
        this.responseName = EXTENSION_OID;
        this.timeOffline = timeOffline;
        this.delay = delay;
        StringBuffer buf = new StringBuffer();
        buf.append("The server will disconnect and will be unavailable for ").append(timeOffline);
        buf.append(" minutes in ").append(delay).append(" seconds.");
        this.ldapResult.setErrorMessage(buf.toString());
        this.ldapResult.setMatchedDn(null);
        this.ldapResult.setResultCode(ResultCodeEnum.UNAVAILABLE);
        this.encodeResponse();
    }

    private void decodeValue() throws DecoderException {
        GracefulDisconnectDecoder decoder = new GracefulDisconnectDecoder();
        org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulDisconnect codec = null;
        try {
            codec = (org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulDisconnect)decoder.decode(this.responseValue);
            this.timeOffline = codec.getTimeOffline();
            this.delay = codec.getDelay();
            this.ldapResult.setResultCode(ResultCodeEnum.SUCCESS);
            List<LdapURL> contexts = codec.getReplicatedContexts();
            for (LdapURL ldapUrl : contexts) {
                this.replicatedContexts.addLdapUrl(ldapUrl.toString());
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_04169, (Object[])new Object[0]), (Throwable)e);
            throw e;
        }
    }

    private void encodeResponse() {
        org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulDisconnect codec = new org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulDisconnect();
        codec.setTimeOffline(this.timeOffline);
        codec.setDelay(this.delay);
        for (String ldapUrlStr : this.replicatedContexts.getLdapUrls()) {
            LdapURL ldapUrl = null;
            try {
                ldapUrl = new LdapURL(ldapUrlStr);
            }
            catch (LdapURLEncodingException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_04170, (Object[])new Object[]{ldapUrlStr}), (Throwable)e);
                continue;
            }
            codec.addReplicatedContexts(ldapUrl);
        }
        try {
            this.responseValue = codec.encode().array();
        }
        catch (EncoderException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_04171, (Object[])new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public byte[] getResponseValue() {
        if (this.responseValue == null) {
            this.encodeResponse();
        }
        byte[] copy = new byte[this.responseValue.length];
        System.arraycopy(this.responseValue, 0, copy, 0, this.responseValue.length);
        return copy;
    }

    public void setResponseValue(byte[] responseValue) {
        ByteBuffer bb = ByteBuffer.wrap(responseValue);
        GracefulDisconnectContainer container = new GracefulDisconnectContainer();
        Asn1Decoder decoder = new Asn1Decoder();
        try {
            decoder.decode(bb, (Asn1Container)container);
        }
        catch (DecoderException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_04172, (Object[])new Object[0]), (Throwable)e);
        }
        org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulDisconnect codec = container.getGracefulDisconnect();
        this.delay = codec.getDelay();
        this.timeOffline = codec.getTimeOffline();
        for (LdapURL ldapUrl : codec.getReplicatedContexts()) {
            this.replicatedContexts.addLdapUrl(ldapUrl.toString());
        }
        if (responseValue != null) {
            this.responseValue = new byte[responseValue.length];
            System.arraycopy(responseValue, 0, this.responseValue, 0, responseValue.length);
        } else {
            this.responseValue = null;
        }
    }

    public String getResponseName() {
        return EXTENSION_OID;
    }

    public void setResponseName(String oid) {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04168, (Object[])new Object[]{EXTENSION_OID}));
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getTimeOffline() {
        return this.timeOffline;
    }

    public void setTimeOffline(int timeOffline) {
        this.timeOffline = timeOffline;
    }

    public Referral getReplicatedContexts() {
        return this.replicatedContexts;
    }
}

