/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.codec.decorators.LdapResultDecorator;
import org.apache.directory.shared.ldap.codec.decorators.ResponseDecorator;
import org.apache.directory.shared.ldap.model.message.ModifyDnResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDnResponseDecorator
extends ResponseDecorator<ModifyDnResponse>
implements ModifyDnResponse {
    private int modifyDnResponseLength;

    public ModifyDnResponseDecorator(LdapCodecService codec, ModifyDnResponse decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setModifyDnResponseLength(int modifyDnResponseLength) {
        this.modifyDnResponseLength = modifyDnResponseLength;
    }

    public int getModifyDnResponseLength() {
        return this.modifyDnResponseLength;
    }

    @Override
    public int computeLength() {
        int modifyDnResponseLength = ((LdapResultDecorator)this.getLdapResult()).computeLength();
        this.setModifyDnResponseLength(modifyDnResponseLength);
        return 1 + TLV.getNbBytes((int)modifyDnResponseLength) + modifyDnResponseLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)109);
            buffer.put(TLV.getBytes((int)this.getModifyDnResponseLength()));
            ((LdapResultDecorator)this.getLdapResult()).encode(buffer);
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]));
        }
        return buffer;
    }
}

