/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.shared.ldap.model.message.ExtendedRequest;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedRequestDecorator
extends SingleReplyRequestDecorator<ExtendedRequest>
implements ExtendedRequest {
    private int extendedRequestLength;
    private byte[] requestNameBytes;

    public ExtendedRequestDecorator(LdapCodecService codec, ExtendedRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setExtendedRequestLength(int extendedRequestLength) {
        this.extendedRequestLength = extendedRequestLength;
    }

    public int getExtendedRequestLength() {
        return this.extendedRequestLength;
    }

    public byte[] getRequestNameBytes() {
        return this.requestNameBytes;
    }

    public void setRequestNameBytes(byte[] requestNameBytes) {
        this.requestNameBytes = requestNameBytes;
    }

    public String getRequestName() {
        return ((ExtendedRequest)this.getDecorated()).getRequestName();
    }

    public void setRequestName(String oid) {
        ((ExtendedRequest)this.getDecorated()).setRequestName(oid);
    }

    public byte[] getRequestValue() {
        return ((ExtendedRequest)this.getDecorated()).getRequestValue();
    }

    public void setRequestValue(byte[] requestValue) {
        ((ExtendedRequest)this.getDecorated()).setRequestValue(requestValue);
    }

    @Override
    public int computeLength() {
        byte[] requestNameBytes = Strings.getBytesUtf8((String)this.getRequestName());
        this.setRequestNameBytes(requestNameBytes);
        int extendedRequestLength = 1 + TLV.getNbBytes((int)requestNameBytes.length) + requestNameBytes.length;
        if (this.getRequestValue() != null) {
            extendedRequestLength += 1 + TLV.getNbBytes((int)this.getRequestValue().length) + this.getRequestValue().length;
        }
        this.setExtendedRequestLength(extendedRequestLength);
        return 1 + TLV.getNbBytes((int)extendedRequestLength) + extendedRequestLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)119);
            buffer.put(TLV.getBytes((int)this.getExtendedRequestLength()));
            if (this.getRequestNameBytes() == null) {
                throw new EncoderException(I18n.err((I18n)I18n.ERR_04043, (Object[])new Object[0]));
            }
            buffer.put((byte)-128);
            buffer.put(TLV.getBytes((int)this.getRequestNameBytes().length));
            if (this.getRequestNameBytes().length != 0) {
                buffer.put(this.getRequestNameBytes());
            }
            if (this.getRequestValue() != null) {
                buffer.put((byte)-127);
                buffer.put(TLV.getBytes((int)this.getRequestValue().length));
                if (this.getRequestValue().length != 0) {
                    buffer.put(this.getRequestValue());
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]));
        }
        return buffer;
    }
}

