/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.AddRequestDecorator;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueAction
extends GrammarAction<LdapMessageContainer<AddRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(ValueAction.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public ValueAction() {
        super("Store a value");
    }

    public void action(LdapMessageContainer<AddRequestDecorator> container) {
        AddRequestDecorator addRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Object value = null;
        if (tlv.getLength() == 0) {
            addRequest.addAttributeValue("");
        } else if (container.isBinary(addRequest.getCurrentAttributeType())) {
            value = tlv.getValue().getData();
            if (IS_DEBUG) {
                LOG.debug("Adding value {}", (Object)Strings.dumpBytes((byte[])value));
            }
            addRequest.addAttributeValue((byte[])value);
        } else {
            value = Strings.utf8ToString((byte[])tlv.getValue().getData());
            if (IS_DEBUG) {
                LOG.debug("Adding value {}" + value);
            }
            addRequest.addAttributeValue((String)value);
        }
        container.setGrammarEndAllowed(true);
    }
}

