/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.SearchResultReferenceDecorator;
import org.apache.directory.shared.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.shared.ldap.model.filter.LdapURL;
import org.apache.directory.shared.ldap.model.message.Referral;
import org.apache.directory.shared.ldap.model.message.ReferralImpl;
import org.apache.directory.shared.ldap.model.message.SearchResultReference;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreReferenceAction
extends GrammarAction<LdapMessageContainer<SearchResultReferenceDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreReferenceAction.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreReferenceAction() {
        super("Store a reference");
    }

    public void action(LdapMessageContainer<SearchResultReferenceDecorator> container) throws DecoderException {
        SearchResultReference searchResultReference = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Referral referral = searchResultReference.getReferral();
        if (referral == null) {
            referral = new ReferralImpl();
            searchResultReference.setReferral(referral);
        }
        LdapURL url = LdapURL.EMPTY_URL;
        if (tlv.getLength() == 0) {
            referral.addLdapUrl("");
        } else {
            String urlStr = Strings.utf8ToString((byte[])tlv.getValue().getData());
            try {
                url = new LdapURL(urlStr);
                referral.addLdapUrl(urlStr);
            }
            catch (LdapURLEncodingException luee) {
                LOG.error(I18n.err((I18n)I18n.ERR_04021, (Object[])new Object[]{urlStr, luee.getMessage()}));
                throw new DecoderException(I18n.err((I18n)I18n.ERR_04016, (Object[])new Object[]{luee.getMessage()}));
            }
        }
        if (IS_DEBUG) {
            LOG.debug("Search reference URL found : {}", (Object)url);
        }
        container.setGrammarEndAllowed(true);
    }
}

