/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.BindResponseDecorator;
import org.apache.directory.shared.ldap.model.message.BindResponse;
import org.apache.directory.shared.util.StringConstants;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSASLCredsAction
extends GrammarAction<LdapMessageContainer<BindResponseDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(ServerSASLCredsAction.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public ServerSASLCredsAction() {
        super("Store server sasl credentials value");
    }

    public void action(LdapMessageContainer<BindResponseDecorator> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        byte[] serverSaslCreds = null;
        serverSaslCreds = tlv.getLength() == 0 ? StringConstants.EMPTY_BYTES : tlv.getValue().getData();
        BindResponse response = container.getMessage();
        response.setServerSaslCreds(serverSaslCreds);
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("The SASL credentials value is : {}", (Object)Strings.dumpBytes((byte[])serverSaslCreds));
        }
    }
}

