/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.util.OID;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.ExtendedResponseDecorator;
import org.apache.directory.shared.ldap.model.message.ExtendedResponse;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseNameAction
extends GrammarAction<LdapMessageContainer<ExtendedResponseDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseNameAction.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public ResponseNameAction() {
        super("Store response name");
    }

    public void action(LdapMessageContainer<ExtendedResponseDecorator> container) throws DecoderException {
        ExtendedResponse extendedResponse = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_04017, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        extendedResponse.setResponseName(new OID(Strings.asciiBytesToString((byte[])tlv.getValue().getData())).toString());
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("OID read : {}", (Object)extendedResponse.getResponseName());
        }
    }
}

