/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.shared.ldap.codec.search.ExtensibleMatchFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitExtensibleMatchFilterAction
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitExtensibleMatchFilterAction.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public InitExtensibleMatchFilterAction() {
        super("Init Extensible Match filter Value");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        ExtensibleMatchFilter extensibleMatchFilter = new ExtensibleMatchFilter(container.getTlvId());
        searchRequestDecorator.addCurrentFilter(extensibleMatchFilter);
        searchRequestDecorator.setTerminalFilter(extensibleMatchFilter);
        if (IS_DEBUG) {
            LOG.debug("Initialize Extensible Match filter");
        }
    }
}

