/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.AttributeValueAssertion;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.shared.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitAttributeDescFilterAction
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitAttributeDescFilterAction.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public InitAttributeDescFilterAction() {
        super("Initialize AttributeDesc filter");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        AttributeValueAssertion assertion = new AttributeValueAssertion();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_04007, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        String type = Strings.utf8ToString((byte[])tlv.getValue().getData());
        assertion.setAttributeDesc(type);
        AttributeValueAssertionFilter terminalFilter = (AttributeValueAssertionFilter)searchRequestDecorator.getTerminalFilter();
        terminalFilter.setAssertion(assertion);
        if (IS_DEBUG) {
            LOG.debug("Initialize AttributeDesc filter");
        }
    }
}

