/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.shared.ldap.codec.search.AttributeValueAssertionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitApproxMatchFilterAction
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitApproxMatchFilterAction.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public InitApproxMatchFilterAction() {
        super("Init Approx Match filter Value");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(container.getTlvId(), 3);
        searchRequestDecorator.addCurrentFilter(filter);
        searchRequestDecorator.setTerminalFilter(filter);
        if (IS_DEBUG) {
            LOG.debug("Initialize Approx Match filter");
        }
    }
}

