/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.AbstractCursor;
import org.apache.directory.shared.ldap.model.cursor.EntryCursor;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.cursor.SearchCursor;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.message.Response;
import org.apache.directory.shared.ldap.model.message.SearchResultDone;
import org.apache.directory.shared.ldap.model.message.SearchResultEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryCursorImpl
extends AbstractCursor<Entry>
implements EntryCursor {
    private Response response;
    private SearchCursor searchCursor;
    private int messageId;

    public EntryCursorImpl(SearchCursor searchCursor) {
        this.searchCursor = searchCursor;
        this.messageId = -1;
    }

    public boolean next() throws Exception {
        if (!this.searchCursor.next()) {
            return false;
        }
        try {
            do {
                this.response = (Response)this.searchCursor.get();
                if (this.response == null) {
                    throw new LdapException("TimeOut occurred");
                }
                this.messageId = this.response.getMessageId();
                if (!(this.response instanceof SearchResultEntry)) continue;
                return true;
            } while (!(this.response instanceof SearchResultDone));
            return false;
        }
        catch (Exception e) {
            LdapException ldapException = new LdapException("The response queue has been emptied, no response was found.");
            ldapException.initCause((Throwable)e);
            this.close((Exception)ldapException);
            throw ldapException;
        }
    }

    public Entry get() throws Exception {
        if (!this.searchCursor.available()) {
            throw new InvalidCursorPositionException();
        }
        do {
            if (!(this.response instanceof SearchResultEntry)) continue;
            return ((SearchResultEntry)this.response).getEntry();
        } while (this.next() && !(this.response instanceof SearchResultDone));
        return null;
    }

    public SearchResultDone getSearchResultDone() {
        return this.searchCursor.getSearchResultDone();
    }

    public boolean available() {
        return this.searchCursor.available();
    }

    public void close() throws Exception {
        this.searchCursor.close();
    }

    public void close(Exception cause) throws Exception {
        this.searchCursor.close(cause);
    }

    public void after(Entry element) throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("after( Response element )")}));
    }

    public void afterLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("afterLast()")}));
    }

    public void before(Entry element) throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("before( Response element )")}));
    }

    public void beforeFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("beforeFirst()")}));
    }

    public boolean first() throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("first()")}));
    }

    public boolean last() throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("last()")}));
    }

    public boolean previous() throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("previous()")}));
    }

    public int getMessageId() {
        return this.messageId;
    }
}

