/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2;

import java.util.HashMap;
import java.util.Map;
import org.apache.directory.shared.dsmlv2.DsmlControl;
import org.apache.directory.shared.dsmlv2.DsmlDecorator;
import org.apache.directory.shared.ldap.codec.api.CodecControl;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.model.exception.MessageException;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.Message;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDsmlMessageDecorator<E extends Message>
implements DsmlDecorator<E>,
Message {
    private final LdapApiService codec;
    private final E message;
    private final Map<String, Control> controls;
    private DsmlControl<? extends Control> currentControl;

    public AbstractDsmlMessageDecorator(LdapApiService codec, E message) {
        this.codec = codec;
        this.message = message;
        this.controls = new HashMap<String, Control>();
    }

    public DsmlControl<? extends Control> getCurrentControl() {
        return this.currentControl;
    }

    public LdapApiService getCodecService() {
        return this.codec;
    }

    public MessageTypeEnum getType() {
        return this.message.getType();
    }

    public Map<String, Control> getControls() {
        return this.controls;
    }

    public Control getControl(String oid) {
        return this.controls.get(oid);
    }

    public boolean hasControl(String oid) {
        return this.controls.containsKey(oid);
    }

    public Message addControl(Control control) throws MessageException {
        Object decorated;
        DsmlControl<CodecControl> decorator;
        if (control instanceof DsmlControl) {
            decorator = (DsmlControl<CodecControl>)control;
            decorated = decorator.getDecorated();
        } else {
            decorator = new DsmlControl<CodecControl>(this.codec, this.codec.newControl(control));
            decorated = control;
        }
        this.message.addControl(decorated);
        this.controls.put(control.getOid(), decorator);
        this.currentControl = decorator;
        return this;
    }

    public Message addAllControls(Control[] controls) throws MessageException {
        for (Control control : controls) {
            this.addControl(control);
        }
        return this;
    }

    public Message removeControl(Control control) throws MessageException {
        this.controls.remove(control.getOid());
        this.message.removeControl(control);
        return this;
    }

    public int getMessageId() {
        return this.message.getMessageId();
    }

    public Object get(Object key) {
        return this.message.get(key);
    }

    public Object put(Object key, Object value) {
        return this.message.put(key, value);
    }

    public Message setMessageId(int messageId) {
        this.message.setMessageId(messageId);
        return this;
    }

    @Override
    public E getDecorated() {
        return this.message;
    }
}

