/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.request;

import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.dsmlv2.request.AbstractRequestDsml;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.codec.extended.ExtendedRequestCodec;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ExtendedRequestDsml
extends AbstractRequestDsml {
    public ExtendedRequestDsml() {
        super((LdapMessageCodec)new ExtendedRequestCodec());
    }

    public ExtendedRequestDsml(ExtendedRequestCodec ldapMessage) {
        super((LdapMessageCodec)ldapMessage);
    }

    public MessageTypeEnum getMessageType() {
        return this.instance.getMessageType();
    }

    public Element toDsml(Element root) {
        Element element = super.toDsml(root);
        ExtendedRequestCodec request = (ExtendedRequestCodec)this.instance;
        if (request.getRequestName() != null) {
            element.addElement("requestName").setText(request.getRequestName());
        }
        Namespace xsdNamespace = new Namespace("xsd", "http://www.w3c.org/2001/XMLSchema");
        Namespace xsiNamespace = new Namespace("xsi", "http://www.w3c.org/2001/XMLSchema-instance");
        element.getDocument().getRootElement().add(xsdNamespace);
        element.getDocument().getRootElement().add(xsiNamespace);
        Element valueElement = element.addElement("requestValue").addText(ParserUtils.base64Encode(request.getRequestValue()));
        valueElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
        return element;
    }

    public String getRequestName() {
        return ((ExtendedRequestCodec)this.instance).getRequestName();
    }

    public void setRequestName(OID requestName) {
        ((ExtendedRequestCodec)this.instance).setRequestName(requestName);
    }

    public byte[] getRequestValue() {
        return ((ExtendedRequestCodec)this.instance).getRequestValue();
    }

    public void setRequestValue(byte[] requestValue) {
        ((ExtendedRequestCodec)this.instance).getRequestValue();
    }
}

