/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.request;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.dsmlv2.DsmlDecorator;
import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.dsmlv2.request.BatchRequest;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class BatchRequestDsml {
    private List<DsmlDecorator> requests = new ArrayList<DsmlDecorator>();
    private int requestID;
    private BatchRequest.Processing processing;
    private BatchRequest.OnError onError;
    private BatchRequest.ResponseOrder responseOrder = BatchRequest.ResponseOrder.SEQUENTIAL;

    public BatchRequestDsml() {
        this.processing = BatchRequest.Processing.SEQUENTIAL;
        this.onError = BatchRequest.OnError.EXIT;
    }

    public boolean addRequest(DsmlDecorator request) {
        return this.requests.add(request);
    }

    public boolean removeRequest(DsmlDecorator request) {
        return this.requests.remove(request);
    }

    public int getRequestID() {
        return this.requestID;
    }

    public void setRequestID(int requestID) {
        this.requestID = requestID;
    }

    public BatchRequest.Processing getProcessing() {
        return this.processing;
    }

    public void setProcessing(BatchRequest.Processing processing) {
        this.processing = processing;
    }

    public BatchRequest.OnError getOnError() {
        return this.onError;
    }

    public void setOnError(BatchRequest.OnError onError) {
        this.onError = onError;
    }

    public BatchRequest.ResponseOrder getResponseOrder() {
        return this.responseOrder;
    }

    public void setResponseOrder(BatchRequest.ResponseOrder responseOrder) {
        this.responseOrder = responseOrder;
    }

    public String toDsml() {
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("batchRequest");
        if (this.requestID != 0) {
            element.addAttribute("requestID", "" + this.requestID);
        }
        if (this.responseOrder == BatchRequest.ResponseOrder.UNORDERED) {
            element.addAttribute("responseOrder", "unordered");
        }
        if (this.processing == BatchRequest.Processing.PARALLEL) {
            element.addAttribute("processing", "parallel");
        }
        if (this.onError == BatchRequest.OnError.RESUME) {
            element.addAttribute("onError", "resume");
        }
        for (DsmlDecorator request : this.requests) {
            request.toDsml(element);
        }
        return ParserUtils.styleDocument(document).asXML();
    }
}

