/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.ber;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.grammar.IStates;
import org.apache.directory.shared.asn1.ber.tlv.TLV;

public class AbstractContainer
implements IAsn1Container {
    protected IGrammar[] grammarStack;
    protected IGrammar[] grammars;
    protected int[] stateStack;
    protected boolean[] popAllowedStack;
    protected int nbGrammars;
    protected int currentGrammar;
    protected int state;
    protected int transition;
    protected TLV tlv;
    protected IStates states;
    protected TLV parentTLV;
    protected boolean grammarEndAllowed;
    protected boolean grammarPopAllowed;

    public IGrammar getGrammar() {
        return this.grammarStack[this.currentGrammar];
    }

    public void addGrammar(IGrammar grammar) {
        this.grammars[this.nbGrammars++] = grammar;
    }

    public void switchGrammar(int currentState, int grammar) {
        this.stateStack[this.currentGrammar] = currentState;
        ++this.currentGrammar;
        this.popAllowedStack[this.currentGrammar] = false;
        this.grammarStack[this.currentGrammar] = this.grammars[(grammar >> 8) - 1];
    }

    public int restoreGrammar() {
        this.grammarStack[this.currentGrammar] = null;
        this.popAllowedStack[this.currentGrammar] = false;
        --this.currentGrammar;
        if (this.currentGrammar >= 0) {
            return this.stateStack[this.currentGrammar];
        }
        return -1;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public boolean isGrammarEndAllowed() {
        return this.grammarEndAllowed;
    }

    public void grammarEndAllowed(boolean grammarEndAllowed) {
        this.grammarEndAllowed = grammarEndAllowed;
    }

    public boolean isGrammarPopAllowed() {
        return this.popAllowedStack[this.currentGrammar];
    }

    public void grammarPopAllowed(boolean grammarPopAllowed) {
        this.popAllowedStack[this.currentGrammar] = grammarPopAllowed;
    }

    public int getTransition() {
        return this.transition;
    }

    public void setTransition(int transition) {
        this.transition = transition;
    }

    public int getCurrentGrammar() {
        return this.currentGrammar;
    }

    public int getCurrentGrammarType() {
        for (int i = 0; i < this.grammars.length; ++i) {
            if (this.grammars[i] != this.grammarStack[this.currentGrammar]) continue;
            return i;
        }
        return -1;
    }

    public void setInitGrammar(int grammar) {
        ++this.currentGrammar;
        this.grammarStack[this.currentGrammar] = this.grammars[grammar];
        this.stateStack[this.currentGrammar] = 0;
    }

    public void setCurrentTLV(TLV tlv) {
        this.tlv = tlv;
    }

    public TLV getCurrentTLV() {
        return this.tlv;
    }

    public IStates getStates() {
        return this.states;
    }

    public TLV getParentTLV() {
        return this.parentTLV;
    }

    public void setParentTLV(TLV parentTLV) {
        this.parentTLV = parentTLV;
    }

    public void clean() {
        this.currentGrammar = 0;
        this.tlv = null;
        this.parentTLV = null;
        this.transition = 0;
        this.state = 0;
    }
}

