/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.der;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERString;

public class DERUniversalString
extends DERString {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public DERUniversalString(byte[] value) {
        super(28, value);
    }

    public String getString() {
        StringBuffer buf = new StringBuffer("#");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream(baos);
        try {
            aos.writeObject(this);
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error encoding BitString.");
        }
        byte[] string = baos.toByteArray();
        int i = 0;
        while (i < string.length) {
            buf.append(table[(string[i] >>> 4) % 15]);
            buf.append(table[string[i] & 0xF]);
            ++i;
        }
        return buf.toString();
    }
}

