/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.der;

import java.io.IOException;
import java.util.Arrays;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DEREncodable;

public abstract class DERObject
implements DEREncodable {
    static final int TERMINATOR = 0;
    static final int BOOLEAN = 1;
    static final int INTEGER = 2;
    static final int BIT_STRING = 3;
    static final int OCTET_STRING = 4;
    static final int NULL = 5;
    static final int OBJECT_IDENTIFIER = 6;
    static final int EXTERNAL = 8;
    static final int ENUMERATED = 10;
    static final int SEQUENCE = 16;
    static final int SET = 17;
    static final int NUMERIC_STRING = 18;
    static final int PRINTABLE_STRING = 19;
    static final int T61_STRING = 20;
    static final int VIDEOTEX_STRING = 21;
    static final int IA5_STRING = 22;
    static final int UTC_TIME = 23;
    static final int GENERALIZED_TIME = 24;
    static final int GRAPHIC_STRING = 25;
    static final int VISIBLE_STRING = 26;
    static final int GENERAL_STRING = 27;
    static final int UNIVERSAL_STRING = 28;
    static final int BMP_STRING = 30;
    static final int UTF8_STRING = 12;
    static final int CONSTRUCTED = 32;
    static final int APPLICATION = 64;
    static final int TAGGED = 128;
    protected int tag;
    protected byte[] value;

    protected DERObject(int tag, byte[] value) {
        this.tag = tag;
        this.value = value;
    }

    public void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(this.tag, this.value);
    }

    byte[] getOctets() {
        return this.value;
    }

    public int hashCode() {
        int hash = 0;
        int len = this.value.length;
        int i = 0;
        while (i < len) {
            if ((hash <<= 1) < 0) {
                hash |= 1;
            }
            hash ^= this.value[i];
            ++i;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DERObject)) {
            return false;
        }
        DERObject that = (DERObject)o;
        return Arrays.equals(this.value, that.value);
    }
}

