/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.der;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DEROctetString;

public class BERConstructedOctetString
extends DEROctetString {
    private Vector octets;

    public BERConstructedOctetString(byte[] string) {
        super(string);
    }

    public BERConstructedOctetString(Vector octets) {
        super(BERConstructedOctetString.toBytes(octets));
        this.octets = octets;
    }

    private static byte[] toBytes(Vector octs) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while (i != octs.size()) {
            try {
                DEROctetString o = (DEROctetString)octs.elementAt(i);
                baos.write(o.getOctets());
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(String.valueOf(octs.elementAt(i).getClass().getName()) + " found in input should only contain DEROctetString.");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Exception converting octets " + e.toString());
            }
            ++i;
        }
        return baos.toByteArray();
    }

    public Enumeration getObjects() {
        if (this.octets == null) {
            return this.generateOcts().elements();
        }
        return this.octets.elements();
    }

    private Vector generateOcts() {
        byte[] nStr;
        int start = 0;
        int end = 0;
        Vector<DEROctetString> vector = new Vector<DEROctetString>();
        while (end + 1 < this.value.length) {
            if (this.value[end] == 0 && this.value[end + 1] == 0) {
                nStr = new byte[end - start + 1];
                System.arraycopy(this.value, start, nStr, 0, nStr.length);
                vector.addElement(new DEROctetString(nStr));
                start = end + 1;
            }
            ++end;
        }
        nStr = new byte[this.value.length - start];
        System.arraycopy(this.value, start, nStr, 0, nStr.length);
        vector.addElement(new DEROctetString(nStr));
        return vector;
    }

    public void encode(ASN1OutputStream out) throws IOException {
        out.write(36);
        out.write(128);
        if (this.octets != null) {
            int i = 0;
            while (i != this.octets.size()) {
                out.writeObject(this.octets.elementAt(i));
                ++i;
            }
        } else {
            byte[] newString;
            int start = 0;
            int end = 0;
            while (end + 1 < this.value.length) {
                if (this.value[end] == 0 && this.value[end + 1] == 0) {
                    newString = new byte[end - start + 1];
                    System.arraycopy(this.value, start, newString, 0, newString.length);
                    out.writeObject(new DEROctetString(newString));
                    start = end + 1;
                }
                ++end;
            }
            newString = new byte[this.value.length - start];
            System.arraycopy(this.value, start, newString, 0, newString.length);
            out.writeObject(new DEROctetString(newString));
        }
        out.write(0);
        out.write(0);
    }
}

