/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.primitives;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;
import org.apache.directory.shared.i18n.I18n;

public class OID
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long[] oidValues;
    private int hash;

    public OID() {
        this.hash = 0;
    }

    public OID(byte[] oid) throws DecoderException {
        this.setOID(oid);
        this.hash = this.computeHashCode();
    }

    public OID(String oid) throws DecoderException {
        this.setOID(oid);
        this.hash = this.computeHashCode();
    }

    public void setOID(byte[] oid) throws DecoderException {
        int pos;
        if (oid == null) {
            throw new DecoderException(I18n.err((String)"ERR_00032", (Object[])new Object[0]));
        }
        if (oid.length < 1) {
            throw new DecoderException(I18n.err((String)"ERR_00033", (Object[])new Object[]{Asn1StringUtils.dumpBytes(oid)}));
        }
        int nbValues = 1;
        for (pos = 0; pos < oid.length; ++pos) {
            if (oid[pos] < 0) continue;
            ++nbValues;
        }
        this.oidValues = new long[nbValues];
        nbValues = 0;
        int accumulator = 0;
        if (oid[0] < 0 || oid[0] >= 80) {
            this.oidValues[nbValues++] = 2L;
            for (pos = 0; pos < oid.length; ++pos) {
                if (oid[pos] >= 0) {
                    this.oidValues[nbValues++] = (accumulator << 7) + oid[pos] - 80;
                    accumulator = 0;
                    ++pos;
                    break;
                }
                accumulator = (accumulator << 7) + (oid[pos] & 0x7F);
            }
        } else if (oid[0] < 40) {
            this.oidValues[nbValues++] = 0L;
            this.oidValues[nbValues++] = oid[pos++];
        } else {
            this.oidValues[nbValues++] = 1L;
            this.oidValues[nbValues++] = oid[pos++] - 40;
        }
        while (pos < oid.length) {
            if (oid[pos] >= 0) {
                this.oidValues[nbValues++] = (accumulator << 7) + oid[pos];
                accumulator = 0;
            } else {
                accumulator = (accumulator << 7) + (oid[pos] & 0x7F);
            }
            ++pos;
        }
        this.hash = this.computeHashCode();
    }

    public void setOID(String oid) throws DecoderException {
        if (oid == null || oid.length() == 0) {
            throw new DecoderException(I18n.err((String)"ERR_00032", (Object[])new Object[0]));
        }
        int nbValues = 1;
        char[] chars = oid.toCharArray();
        boolean dotSeen = false;
        for (char c : chars) {
            if (c == '.') {
                if (dotSeen) {
                    throw new DecoderException(I18n.err((String)"ERR_00033", (Object[])new Object[]{oid}));
                }
                ++nbValues;
                dotSeen = true;
                continue;
            }
            dotSeen = false;
        }
        if (nbValues < 2) {
            throw new DecoderException(I18n.err((String)"ERR_00033", (Object[])new Object[]{oid}));
        }
        this.oidValues = new long[nbValues];
        int pos = 0;
        int intPos = 0;
        boolean ituOrIso = false;
        switch (chars[pos]) {
            case '0': 
            case '1': {
                ituOrIso = true;
            }
            case '2': {
                this.oidValues[intPos++] = chars[pos++] - 48;
                break;
            }
            default: {
                throw new DecoderException(I18n.err((String)"ERR_00033", (Object[])new Object[]{oid}));
            }
        }
        if (chars[pos++] != '.') {
            throw new DecoderException(I18n.err((String)"ERR_00033", (Object[])new Object[]{oid}));
        }
        dotSeen = true;
        int value = 0;
        for (int i = pos; i < chars.length; ++i) {
            if (chars[i] == '.') {
                if (dotSeen) {
                    throw new DecoderException(I18n.err((String)"ERR_00033", (Object[])new Object[]{oid}));
                }
                if (ituOrIso && value > 39) {
                    throw new DecoderException(I18n.err((String)"ERR_00033", (Object[])new Object[]{oid}));
                }
                ituOrIso = false;
                ++nbValues;
                dotSeen = true;
                this.oidValues[intPos++] = value;
                value = 0;
                continue;
            }
            if (chars[i] >= '0' && chars[i] <= '9') {
                dotSeen = false;
                value = value * 10 + chars[i] - 48;
                continue;
            }
            throw new DecoderException(I18n.err((String)"ERR_00033", (Object[])new Object[]{oid}));
        }
        this.oidValues[intPos] = value;
        this.hash = this.computeHashCode();
    }

    public long[] getOIDValues() {
        return this.oidValues;
    }

    public int getOIDLength() {
        long value = this.oidValues[0] * 40L + this.oidValues[1];
        int nbBytes = 0;
        nbBytes = value < 128L ? 1 : (value < 16384L ? 2 : (value < 0x200000L ? 3 : (value < 0x10000000L ? 4 : 5)));
        for (int i = 2; i < this.oidValues.length; ++i) {
            value = this.oidValues[i];
            if (value < 128L) {
                ++nbBytes;
                continue;
            }
            if (value < 16384L) {
                nbBytes += 2;
                continue;
            }
            if (value < 0x200000L) {
                nbBytes += 3;
                continue;
            }
            if (value < 0x10000000L) {
                nbBytes += 4;
                continue;
            }
            nbBytes += 5;
        }
        return nbBytes;
    }

    public byte[] getOID() {
        long value;
        long firstValues = value = this.oidValues[0] * 40L + this.oidValues[1];
        byte[] bytes = new byte[this.getOIDLength()];
        int pos = 0;
        if (this.oidValues[0] < 2L) {
            bytes[pos++] = (byte)(this.oidValues[0] * 40L + this.oidValues[1]);
        } else if (firstValues < 128L) {
            bytes[pos++] = (byte)firstValues;
        } else if (firstValues < 16384L) {
            bytes[pos++] = (byte)(firstValues >> 7 | 0x80L);
            bytes[pos++] = (byte)(firstValues & 0x7FL);
        } else if (value < 0x200000L) {
            bytes[pos++] = (byte)(firstValues >> 14 | 0x80L);
            bytes[pos++] = (byte)(firstValues >> 7 & 0x7FL | 0x80L);
            bytes[pos++] = (byte)(firstValues & 0x7FL);
        } else if (value < 0x10000000L) {
            bytes[pos++] = (byte)(firstValues >> 21 | 0x80L);
            bytes[pos++] = (byte)(firstValues >> 14 & 0x7FL | 0x80L);
            bytes[pos++] = (byte)(firstValues >> 7 & 0x7FL | 0x80L);
            bytes[pos++] = (byte)(firstValues & 0x7FL);
        } else {
            bytes[pos++] = (byte)(firstValues >> 28 | 0x80L);
            bytes[pos++] = (byte)(firstValues >> 21 & 0x7FL | 0x80L);
            bytes[pos++] = (byte)(firstValues >> 14 & 0x7FL | 0x80L);
            bytes[pos++] = (byte)(firstValues >> 7 & 0x7FL | 0x80L);
            bytes[pos++] = (byte)(firstValues & 0x7FL);
        }
        for (int i = 2; i < this.oidValues.length; ++i) {
            value = this.oidValues[i];
            if (value < 128L) {
                bytes[pos++] = (byte)value;
                continue;
            }
            if (value < 16384L) {
                bytes[pos++] = (byte)(value >> 7 | 0x80L);
                bytes[pos++] = (byte)(value & 0x7FL);
                continue;
            }
            if (value < 0x200000L) {
                bytes[pos++] = (byte)(value >> 14 | 0x80L);
                bytes[pos++] = (byte)(value >> 7 & 0x7FL | 0x80L);
                bytes[pos++] = (byte)(value & 0x7FL);
                continue;
            }
            if (value < 0x10000000L) {
                bytes[pos++] = (byte)(value >> 21 | 0x80L);
                bytes[pos++] = (byte)(value >> 14 & 0x7FL | 0x80L);
                bytes[pos++] = (byte)(value >> 7 & 0x7FL | 0x80L);
                bytes[pos++] = (byte)(value & 0x7FL);
                continue;
            }
            bytes[pos++] = (byte)(value >> 28 | 0x80L);
            bytes[pos++] = (byte)(value >> 21 & 0x7FL | 0x80L);
            bytes[pos++] = (byte)(value >> 14 & 0x7FL | 0x80L);
            bytes[pos++] = (byte)(value >> 7 & 0x7FL | 0x80L);
            bytes[pos++] = (byte)(value & 0x7FL);
        }
        return bytes;
    }

    private int computeHashCode() {
        int h = 37;
        for (long val : this.oidValues) {
            int low = (int)(val & 0xFFFFL);
            int high = (int)(val >> 32);
            h = h * 17 + high;
            h = h * 17 + low;
        }
        return h;
    }

    public static boolean isOID(String oid) {
        if (oid == null || oid.length() == 0) {
            return false;
        }
        int nbValues = 1;
        byte[] bytes = oid.getBytes();
        boolean dotSeen = false;
        for (byte b : bytes) {
            if (b == 46) {
                if (dotSeen) {
                    return false;
                }
                ++nbValues;
                dotSeen = true;
                continue;
            }
            dotSeen = false;
        }
        if (nbValues < 2) {
            return false;
        }
        int pos = 0;
        boolean ituOrIso = false;
        switch (bytes[pos++]) {
            case 48: 
            case 49: {
                ituOrIso = true;
            }
            case 50: {
                break;
            }
            default: {
                return false;
            }
        }
        if (bytes[pos++] != 46) {
            return false;
        }
        dotSeen = true;
        long value = 0L;
        for (int i = pos; i < bytes.length; ++i) {
            if (bytes[i] == 46) {
                if (dotSeen) {
                    return false;
                }
                if (ituOrIso && value > 39L) {
                    return false;
                }
                ituOrIso = false;
                ++nbValues;
                dotSeen = true;
                value = 0L;
                continue;
            }
            if (bytes[i] >= 48 && bytes[i] <= 57) {
                dotSeen = false;
                value = value * 10L + (long)bytes[i] - 48L;
                continue;
            }
            return false;
        }
        return !dotSeen;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.oidValues != null) {
            sb.append(this.oidValues[0]);
            for (int i = 1; i < this.oidValues.length; ++i) {
                sb.append('.').append(this.oidValues[i]);
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object oid) {
        if (this == oid) {
            return true;
        }
        if (oid == null) {
            return false;
        }
        if (oid.getClass() != this.getClass()) {
            return false;
        }
        OID instance = (OID)oid;
        if (instance.hash != this.hash) {
            return false;
        }
        return Arrays.equals(instance.oidValues, this.oidValues);
    }
}

