/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.kerberos.credentials.cache;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.kerberos.credentials.cache.CacheInputStream;
import org.apache.directory.kerberos.credentials.cache.CacheOutputStream;
import org.apache.directory.kerberos.credentials.cache.Credentials;
import org.apache.directory.kerberos.credentials.cache.SampleCredentialsCacheResource;
import org.apache.directory.kerberos.credentials.cache.Tag;
import org.apache.directory.shared.kerberos.components.PrincipalName;

public class CredentialsCache {
    private int version = 1284;
    private List<Tag> tags;
    private PrincipalName primaryPrincipal;
    private List<Credentials> credentialsList = new ArrayList<Credentials>();

    public static CredentialsCache load(File cacheFile) throws IOException {
        return CredentialsCache.load(new FileInputStream(cacheFile));
    }

    public static CredentialsCache load(InputStream is) throws IOException {
        CacheInputStream cis = new CacheInputStream(is);
        CredentialsCache credCache = new CredentialsCache();
        cis.read(credCache);
        cis.close();
        return credCache;
    }

    public static void store(File fileName, CredentialsCache credCache) throws IOException {
        CredentialsCache.store(new FileOutputStream(fileName), credCache);
    }

    public static void store(OutputStream os, CredentialsCache credCache) throws IOException {
        CacheOutputStream cos = new CacheOutputStream(os);
        cos.write(credCache);
        cos.close();
    }

    public void addCredentials(Credentials cred) {
        this.credentialsList.add(cred);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public PrincipalName getPrimaryPrincipalName() {
        return this.primaryPrincipal;
    }

    public void setPrimaryPrincipalName(PrincipalName principal) {
        this.primaryPrincipal = principal;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public List<Credentials> getCredsList() {
        return this.credentialsList;
    }

    public static void main(String[] args) throws IOException {
        CredentialsCache cc;
        String cacheFile;
        String dumpFile = File.createTempFile("credCache-", ".cc").getAbsolutePath();
        System.out.println("This tool tests CredentialsCache reading and writing, and will load the built-in sample credentials cache by default, and dump to " + dumpFile);
        System.out.println("To specify your own credentials cache file, run this as: CredentialsCache [cred-cache-file] ");
        System.out.println("When dumped successfully, run 'klist -e -c' from MIT to check the dumped file");
        String string = cacheFile = args.length > 0 ? args[0] : null;
        if (cacheFile == null) {
            byte[] sampleCache = SampleCredentialsCacheResource.getCacheContent();
            ByteArrayInputStream bais = new ByteArrayInputStream(sampleCache);
            cc = CredentialsCache.load(bais);
        } else {
            cc = CredentialsCache.load(new File(cacheFile));
        }
        if (cc != null) {
            System.out.println("Reading credentials cache is successful");
            File tmpCacheFile = new File(dumpFile);
            tmpCacheFile.delete();
            CredentialsCache.store(tmpCacheFile, cc);
            System.out.println("Writing credentials cache successfully to: " + dumpFile);
        }
    }
}

