/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.kerberos.credentials.cache;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.kerberos.credentials.cache.Credentials;
import org.apache.directory.kerberos.credentials.cache.CredentialsCache;
import org.apache.directory.kerberos.credentials.cache.Tag;
import org.apache.directory.server.kerberos.protocol.codec.KerberosDecoder;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.codec.types.AuthorizationType;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.codec.types.HostAddrType;
import org.apache.directory.shared.kerberos.components.AuthorizationData;
import org.apache.directory.shared.kerberos.components.AuthorizationDataEntry;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.components.HostAddress;
import org.apache.directory.shared.kerberos.components.HostAddresses;
import org.apache.directory.shared.kerberos.components.PrincipalName;
import org.apache.directory.shared.kerberos.flags.TicketFlags;

public class CacheInputStream
extends DataInputStream {
    public CacheInputStream(InputStream in) {
        super(in);
    }

    public void read(CredentialsCache cache) throws IOException {
        int version = this.readVersion();
        cache.setVersion(version);
        List<Tag> tags = version == 1284 ? this.readTag() : null;
        cache.setTags(tags);
        PrincipalName principal = this.readPrincipal(version);
        cache.setPrimaryPrincipalName(principal);
        while (this.available() > 0) {
            Credentials cred = this.readCredentials(version);
            if (cred == null) continue;
            cache.addCredentials(cred);
        }
    }

    private int readVersion() throws IOException {
        short result = this.readShort();
        return result;
    }

    private List<Tag> readTag() throws IOException {
        short taglen;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        block3: for (int len = this.readShort(); len > 0; len -= 4 + taglen) {
            short tag = this.readShort();
            taglen = this.readShort();
            switch (tag) {
                case 1: {
                    int time = this.readInt();
                    int usec = this.readInt();
                    tags.add(new Tag(tag, time, usec));
                    continue block3;
                }
                default: {
                    this.read(new byte[taglen], 0, taglen);
                }
            }
        }
        return tags;
    }

    private PrincipalName readPrincipal(int version) throws IOException {
        int type = version == 1281 ? 0 : this.readInt();
        int length = this.readInt();
        if (version == 1281) {
            --length;
        }
        String realm = this.readCountedString();
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.readCountedString();
        }
        PrincipalName pname = new PrincipalName(result, type);
        if (CacheInputStream.isRealm(realm)) {
            pname.setRealm(realm);
        }
        return pname;
    }

    private String readCountedString() throws IOException {
        int namelength = this.readInt();
        if (namelength > 1024) {
            throw new IOException("Invalid name length in principal name.");
        }
        byte[] bytes = new byte[namelength];
        this.read(bytes, 0, bytes.length);
        return new String(bytes);
    }

    private static boolean isRealm(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char chr = str.charAt(i);
            if (chr == '.' || chr < 'a') continue;
            return false;
        }
        return true;
    }

    private EncryptionKey readKey(int version) throws IOException {
        short keyType = this.readShort();
        if (version == 1283) {
            this.readShort();
        }
        int keyLen = this.readInt();
        byte[] bytes = new byte[keyLen];
        this.read(bytes, 0, bytes.length);
        return new EncryptionKey(EncryptionType.getTypeByValue((int)keyType), bytes);
    }

    private KerberosTime[] readKerberosTimes() throws IOException {
        long[] times = this.readTimes();
        KerberosTime[] results = new KerberosTime[times.length];
        for (int i = 0; i < times.length; ++i) {
            KerberosTime ktime;
            results[i] = ktime = times[i] == 0L ? null : new KerberosTime(times[i]);
        }
        return results;
    }

    private long[] readTimes() throws IOException {
        long[] times = new long[]{(long)this.readInt() * 1000L, (long)this.readInt() * 1000L, (long)this.readInt() * 1000L, (long)this.readInt() * 1000L};
        return times;
    }

    private boolean readskey() throws IOException {
        return this.read() != 0;
    }

    private HostAddress[] readAddr() throws IOException {
        int numAddrs = this.readInt();
        if (numAddrs > 0) {
            HostAddress[] addrs = new HostAddress[numAddrs];
            for (int i = 0; i < numAddrs; ++i) {
                short addrType = this.readShort();
                int addrLength = this.readInt();
                if (addrLength != 4 && addrLength != 16) {
                    return null;
                }
                byte[] result = new byte[addrLength];
                for (int j = 0; j < addrLength; ++j) {
                    result[j] = this.readByte();
                }
                addrs[i] = new HostAddress(HostAddrType.getTypeByOrdinal((int)addrType), result);
            }
            return addrs;
        }
        return null;
    }

    private AuthorizationDataEntry[] readAuth() throws IOException {
        int num = this.readInt();
        if (num > 0) {
            AuthorizationDataEntry[] auData = new AuthorizationDataEntry[num];
            byte[] data = null;
            for (int i = 0; i < num; ++i) {
                short adtype = this.readShort();
                int adlength = this.readInt();
                data = new byte[adlength];
                this.read(data, 0, data.length);
                auData[i] = new AuthorizationDataEntry(AuthorizationType.getTypeByValue((int)adtype), data);
            }
            return auData;
        }
        return null;
    }

    private byte[] readData() throws IOException {
        int length = this.readInt();
        if (length == 0) {
            return null;
        }
        byte[] bytes = new byte[length];
        this.read(bytes, 0, length);
        return bytes;
    }

    private int readFlags() throws IOException {
        int ticketFlags = this.readInt();
        return ticketFlags;
    }

    private Credentials readCredentials(int version) throws IOException {
        PrincipalName cpname = this.readPrincipal(version);
        PrincipalName spname = this.readPrincipal(version);
        if (cpname == null || spname == null) {
            throw new IOException("Invalid client principal name or service principal name");
        }
        EncryptionKey key = this.readKey(version);
        KerberosTime[] times = this.readKerberosTimes();
        KerberosTime authtime = times[0];
        KerberosTime starttime = times[1];
        KerberosTime endtime = times[2];
        KerberosTime renewTill = times[3];
        boolean skey = this.readskey();
        int flags = this.readFlags();
        TicketFlags tFlags = new TicketFlags(flags);
        HostAddress[] addr = this.readAddr();
        HostAddresses addrs = null;
        if (addr != null) {
            addrs = new HostAddresses(addr);
        }
        AuthorizationDataEntry[] auDataEntries = this.readAuth();
        AuthorizationData auData = null;
        if (auDataEntries != null) {
            auData = new AuthorizationData();
            for (AuthorizationDataEntry ade : auDataEntries) {
                auData.addEntry(ade);
            }
        }
        byte[] ticketData = this.readData();
        byte[] ticketData2 = this.readData();
        if (version != 1281 && spname.getNameType().getValue() == 0) {
            return null;
        }
        try {
            return new Credentials(cpname, spname, key, authtime, starttime, endtime, renewTill, skey, tFlags, addrs, auData, ticketData != null ? KerberosDecoder.decodeTicket((byte[])ticketData) : null, ticketData2 != null ? KerberosDecoder.decodeTicket((byte[])ticketData2) : null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

