/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.kerberos.client;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.kerberos.codec.etypeInfo.ETypeInfoContainer;
import org.apache.directory.shared.kerberos.codec.etypeInfo2.ETypeInfo2Container;
import org.apache.directory.shared.kerberos.codec.methodData.MethodDataContainer;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.codec.types.PaDataType;
import org.apache.directory.shared.kerberos.components.ETypeInfo;
import org.apache.directory.shared.kerberos.components.ETypeInfo2;
import org.apache.directory.shared.kerberos.components.ETypeInfo2Entry;
import org.apache.directory.shared.kerberos.components.ETypeInfoEntry;
import org.apache.directory.shared.kerberos.components.MethodData;
import org.apache.directory.shared.kerberos.components.PaData;
import org.apache.directory.shared.kerberos.messages.KrbError;

public class KdcClientUtil {
    public static String extractRealm(String principal) {
        int pos = principal.indexOf(64);
        if (pos > 0) {
            return principal.substring(pos + 1);
        }
        throw new IllegalArgumentException("Not a valid principal, missing realm name");
    }

    public static String extractName(String principal) {
        int pos = principal.indexOf(64);
        if (pos < 0) {
            return principal;
        }
        return principal.substring(0, pos);
    }

    public static Set<EncryptionType> getEtypesFromError(KrbError error) {
        try {
            ByteBuffer stream = ByteBuffer.wrap(error.getEData());
            Asn1Decoder decoder = new Asn1Decoder();
            MethodDataContainer container = new MethodDataContainer();
            container.setStream(stream);
            decoder.decode(stream, (Asn1Container)container);
            MethodData methodData = container.getMethodData();
            for (PaData pd : methodData.getPaDatas()) {
                if (pd.getPaDataType() == PaDataType.PA_ENCTYPE_INFO2) {
                    return KdcClientUtil.parseEtpeInfo2(pd.getPaDataValue());
                }
                if (pd.getPaDataType() != PaDataType.PA_ENCTYPE_INFO) continue;
                return KdcClientUtil.parseEtpeInfo(pd.getPaDataValue());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Collections.EMPTY_SET;
    }

    private static Set<EncryptionType> parseEtpeInfo2(byte[] data) throws DecoderException {
        ByteBuffer stream = ByteBuffer.wrap(data);
        Asn1Decoder decoder = new Asn1Decoder();
        ETypeInfo2Container container = new ETypeInfo2Container();
        container.setStream(stream);
        decoder.decode(stream, (Asn1Container)container);
        ETypeInfo2 info2 = container.getETypeInfo2();
        LinkedHashSet<EncryptionType> lstEtypes = new LinkedHashSet<EncryptionType>();
        for (ETypeInfo2Entry e2e : info2.getETypeInfo2Entries()) {
            lstEtypes.add(e2e.getEType());
        }
        return lstEtypes;
    }

    private static Set<EncryptionType> parseEtpeInfo(byte[] data) throws DecoderException {
        ByteBuffer stream = ByteBuffer.wrap(data);
        Asn1Decoder decoder = new Asn1Decoder();
        ETypeInfoContainer container = new ETypeInfoContainer();
        container.setStream(stream);
        decoder.decode(stream, (Asn1Container)container);
        ETypeInfo einfo = container.getETypeInfo();
        LinkedHashSet<EncryptionType> lstEtypes = new LinkedHashSet<EncryptionType>();
        for (ETypeInfoEntry eie : einfo.getETypeInfoEntries()) {
            lstEtypes.add(eie.getEType());
        }
        return lstEtypes;
    }
}

