/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.kerberos.client;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public class KerberosChannel {
    private Socket tcpSocket;
    private DatagramSocket udpSocket;
    private DataInputStream in;
    private OutputStream out;
    private boolean useUdp;
    private int timeOut = 60000;
    private SocketAddress udpServerAddr = null;

    protected void openConnection(String hostName, int portNo, int timeOut, boolean isUdp) throws IOException {
        this.useUdp = isUdp;
        this.timeOut = timeOut;
        if (isUdp) {
            this.udpServerAddr = new InetSocketAddress(hostName, portNo);
            this.udpSocket = new DatagramSocket();
        } else {
            this.tcpSocket = new Socket(hostName, portNo);
            this.tcpSocket.setSoTimeout(timeOut);
            this.in = new DataInputStream(this.tcpSocket.getInputStream());
            this.out = this.tcpSocket.getOutputStream();
        }
    }

    protected ByteBuffer sendAndReceive(ByteBuffer encodedBuf) throws IOException {
        ByteBuffer repData;
        byte[] reqData = encodedBuf.array();
        if (this.useUdp) {
            DatagramPacket reqPacket = new DatagramPacket(reqData, reqData.length, this.udpServerAddr);
            this.udpSocket.send(reqPacket);
            byte[] buffer = new byte[2048];
            DatagramPacket repPacket = new DatagramPacket(buffer, buffer.length);
            this.udpSocket.receive(repPacket);
            byte[] receivedData = repPacket.getData();
            repData = ByteBuffer.allocate(receivedData.length);
            repData.put(receivedData);
        } else {
            this.out.write(reqData);
            this.out.flush();
            int len = this.in.readInt();
            repData = ByteBuffer.allocate(len + 4);
            repData.putInt(len);
            byte[] tmp = new byte[8192];
            while (this.in.available() > 0) {
                int read = this.in.read(tmp);
                repData.put(tmp, 0, read);
            }
        }
        repData.flip();
        return repData;
    }

    protected boolean isUseTcp() {
        return !this.useUdp;
    }

    protected void close() throws IOException {
        if (this.useUdp) {
            if (this.udpSocket != null) {
                this.udpSocket.close();
            }
        } else if (this.tcpSocket != null) {
            this.tcpSocket.close();
        }
    }
}

