/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.util.regex.Pattern;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralizedTimeSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralizedTimeSyntaxChecker.class);
    private static final String GENERALIZED_TIME_PATTERN = "^\\d{4}(0[1-9]|1[0-2])(0[1-9]|[12]\\d|3[01])([01]\\d|2[0-3])(([0-5]\\d)([0-5]\\d|60)?)?([.,]\\d+)?(Z|[+-]([01]\\d|2[0-3])([0-5]\\d)?)$";
    private static final Pattern DATE_PATTERN = Pattern.compile("^\\d{4}(0[1-9]|1[0-2])(0[1-9]|[12]\\d|3[01])([01]\\d|2[0-3])(([0-5]\\d)([0-5]\\d|60)?)?([.,]\\d+)?(Z|[+-]([01]\\d|2[0-3])([0-5]\\d)?)$");

    public GeneralizedTimeSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.24");
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() < 11) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        boolean result = DATE_PATTERN.matcher(strValue).find();
        if (result) {
            LOG.debug("Syntax valid for '{}'", value);
        } else {
            LOG.debug("Syntax invalid for '{}'", value);
        }
        return result;
    }
}

