/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.syntaxCheckers;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.apache.directory.shared.util.Chars;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DseTypeSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(DseTypeSyntaxChecker.class);
    private static final String[] DSE_BITS_STRINGS = new String[]{"root", "glue", "cp", "entry", "alias", "subr", "nssr", "supr", "xr", "admPoint", "subentry", "shadow", "zombie", "immSupr", "rhob", "sa"};
    private static final Set<String> DSE_BITS = new HashSet<String>();

    public DseTypeSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.20");
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() < 4) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        if (strValue.charAt(0) != '(' || strValue.charAt(strValue.length() - 1) != ')') {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        HashSet<String> keywords = new HashSet<String>();
        int len = strValue.length() - 1;
        boolean needKeyword = true;
        int i = 1;
        while (i < len) {
            while (i < len && strValue.charAt(i) == ' ') {
                ++i;
            }
            int pos = i;
            while (i < len && Chars.isAlphaASCII(strValue, pos)) {
                ++pos;
            }
            if (pos == i) {
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
            String keyword = strValue.substring(i, pos);
            if (!DSE_BITS.contains(keyword)) {
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
            if (keywords.contains(keyword)) {
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
            keywords.add(keyword);
            needKeyword = false;
            for (i = pos; i < len && strValue.charAt(i) == ' '; ++i) {
            }
            if (i >= len || strValue.charAt(i) != '$') continue;
            ++i;
            needKeyword = true;
        }
        if (needKeyword) {
            LOG.debug("Syntax invalid for '{}'", value);
        } else {
            LOG.debug("Syntax valid for '{}'", value);
        }
        return !needKeyword;
    }

    static {
        for (String country : DSE_BITS_STRINGS) {
            DSE_BITS.add(country);
        }
    }
}

