/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.name;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Ava;
import org.apache.directory.shared.ldap.model.name.ComplexDnParser;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.FastDnParser;
import org.apache.directory.shared.ldap.model.name.TooComplexException;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.normalizers.OidNormalizer;
import org.apache.directory.shared.util.Chars;
import org.apache.directory.shared.util.Hex;
import org.apache.directory.shared.util.StringConstants;
import org.apache.directory.shared.util.Strings;
import org.apache.directory.shared.util.Unicode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rdn
implements Cloneable,
Externalizable,
Iterable<Ava>,
Comparable<Rdn> {
    protected static final Logger LOG = LoggerFactory.getLogger(Rdn.class);
    public static final Rdn EMPTY_RDN = new Rdn();
    private static final long serialVersionUID = 1L;
    private String upName = null;
    private String normName = null;
    private List<Ava> avas = null;
    private MultiMap avaTypes = new MultiValueMap();
    private String avaType = null;
    protected Ava ava = null;
    private int nbAvas = 0;
    public static final int UNDEFINED = Integer.MAX_VALUE;
    public static final int SUPERIOR = 1;
    public static final int INFERIOR = -1;
    public static final int EQUAL = 0;
    private boolean normalized = false;
    private SchemaManager schemaManager;
    private volatile int h;

    public Rdn() {
        this((SchemaManager)null);
    }

    public Rdn(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.upName = "";
        this.normName = "";
        this.normalized = false;
        this.h = 0;
    }

    public Rdn(SchemaManager schemaManager, String rdn) throws LdapInvalidDnException {
        if (Strings.isNotEmpty(rdn)) {
            Rdn.parse(rdn, this);
            if (schemaManager != null) {
                this.schemaManager = schemaManager;
                this.apply(schemaManager);
                this.normalized = true;
            } else {
                this.normalize();
                this.normalized = false;
            }
            if (this.upName.length() < rdn.length()) {
                throw new LdapInvalidDnException("Invalid RDN");
            }
            this.upName = rdn;
        } else {
            this.upName = "";
            this.normName = "";
            this.normalized = false;
        }
        this.hashCode();
    }

    public Rdn(String rdn) throws LdapInvalidDnException {
        this((SchemaManager)null, rdn);
    }

    public Rdn(SchemaManager schemaManager, String upType, String upValue) throws LdapInvalidDnException {
        this.addAVA(schemaManager, upType, upType, new StringValue(upValue), new StringValue(upValue));
        this.upName = upType + '=' + upValue;
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            this.apply(schemaManager);
            this.normalized = true;
        } else {
            this.normalize();
            this.normalized = false;
        }
        this.hashCode();
    }

    public Rdn(String upType, String upValue) throws LdapInvalidDnException {
        this(null, upType, upValue);
    }

    public Rdn(Rdn rdn) {
        this.nbAvas = rdn.size();
        this.normName = rdn.normName;
        this.upName = rdn.getName();
        this.normalized = rdn.normalized;
        this.schemaManager = rdn.schemaManager;
        switch (rdn.size()) {
            case 0: {
                this.hashCode();
                return;
            }
            case 1: {
                this.ava = rdn.ava.clone();
                this.hashCode();
                return;
            }
        }
        this.avas = new ArrayList<Ava>();
        this.avaTypes = new MultiValueMap();
        for (Ava currentAva : rdn.avas) {
            this.avas.add(currentAva.clone());
            this.avaTypes.put(currentAva.getNormType(), currentAva);
        }
        this.hashCode();
    }

    void normalize() {
        switch (this.nbAvas) {
            case 0: {
                this.normName = "";
                break;
            }
            case 1: {
                if (this.ava.getNormValue().isHumanReadable()) {
                    this.normName = this.ava.getNormName();
                    break;
                }
                this.normName = this.ava.getNormType() + "=#" + Strings.dumpHexPairs(this.ava.getNormValue().getBytes());
                break;
            }
            default: {
                StringBuffer sb = new StringBuffer();
                boolean isFirst = true;
                for (Ava ata : this.avas) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append('+');
                    }
                    sb.append(ata.getNormName());
                }
                this.normName = sb.toString();
            }
        }
        this.hashCode();
    }

    public Rdn apply(SchemaManager schemaManager) throws LdapInvalidDnException {
        if (this.normalized) {
            return this;
        }
        String savedUpName = this.getName();
        Dn.rdnOidToName(this, schemaManager);
        this.normalize();
        this.upName = savedUpName;
        this.normalized = true;
        this.schemaManager = schemaManager;
        this.hashCode();
        return this;
    }

    private void addAVA(SchemaManager schemaManager, String upType, String type, Value<?> upValue, Value<?> value) throws LdapInvalidDnException {
        Value<?> normalizedValue = value;
        String normalizedType = Strings.lowerCaseAscii(type);
        this.schemaManager = schemaManager;
        if (schemaManager != null) {
            OidNormalizer oidNormalizer = schemaManager.getNormalizerMapping().get(normalizedType);
            normalizedType = oidNormalizer.getAttributeTypeOid();
            try {
                normalizedValue = oidNormalizer.getNormalizer().normalize(value);
            }
            catch (LdapException e) {
                throw new LdapInvalidDnException(e.getMessage(), e);
            }
        }
        switch (this.nbAvas) {
            case 0: {
                this.ava = new Ava(schemaManager, upType, normalizedType, upValue, normalizedValue);
                this.nbAvas = 1;
                this.avaType = normalizedType;
                this.hashCode();
                return;
            }
            case 1: {
                this.avas = new ArrayList<Ava>();
                this.avas.add(this.ava);
                this.avaTypes = new MultiValueMap();
                this.avaTypes.put(this.avaType, this.ava);
                this.ava = null;
            }
        }
        Ava newAva = new Ava(schemaManager, upType, normalizedType, upValue, normalizedValue);
        this.avas.add(newAva);
        this.avaTypes.put(normalizedType, newAva);
        ++this.nbAvas;
        this.hashCode();
    }

    void addAVA(SchemaManager schemaManager, Ava value) throws LdapInvalidDnException {
        this.schemaManager = schemaManager;
        String normalizedType = value.getNormType();
        switch (this.nbAvas) {
            case 0: {
                this.ava = value;
                this.nbAvas = 1;
                this.avaType = normalizedType;
                this.hashCode();
                return;
            }
            case 1: {
                if (this.avaType.equals(normalizedType)) {
                    throw new LdapInvalidDnException("Invalid RDN: the " + normalizedType + " is already present in the RDN");
                }
                this.avas = new ArrayList<Ava>();
                this.avas.add(this.ava);
                this.avaTypes = new MultiValueMap();
                this.avaTypes.put(this.avaType, this.ava);
                this.ava = null;
            }
        }
        if (this.avaTypes.containsKey(normalizedType)) {
            throw new LdapInvalidDnException("Invalid RDN: the " + normalizedType + " is already present in the RDN");
        }
        this.avas.add(value);
        this.avaTypes.put(normalizedType, value);
        ++this.nbAvas;
        this.hashCode();
    }

    void clear() {
        this.ava = null;
        this.avas = null;
        this.avaType = null;
        this.avaTypes.clear();
        this.nbAvas = 0;
        this.normName = "";
        this.upName = "";
        this.normalized = false;
        this.h = 0;
    }

    public Object getValue(String type) throws LdapInvalidDnException {
        AttributeType attributeType;
        String normalizedType = Strings.lowerCaseAscii(Strings.trim(type));
        if (this.schemaManager != null && (attributeType = this.schemaManager.getAttributeType(normalizedType)) != null) {
            normalizedType = attributeType.getOid();
        }
        switch (this.nbAvas) {
            case 0: {
                return "";
            }
            case 1: {
                if (Strings.equals(this.ava.getNormType(), normalizedType)) {
                    return this.ava.getNormValue().getValue();
                }
                return "";
            }
        }
        if (this.avaTypes.containsKey(normalizedType)) {
            Collection atavList = (Collection)this.avaTypes.get(normalizedType);
            StringBuffer sb = new StringBuffer();
            boolean isFirst = true;
            for (Ava elem : atavList) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                sb.append(elem.getNormValue());
            }
            return sb.toString();
        }
        return "";
    }

    public Ava getAva(String type) {
        String normalizedType = Strings.lowerCaseAscii(Strings.trim(type));
        switch (this.nbAvas) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.ava.getNormType().equals(normalizedType)) {
                    return this.ava;
                }
                return null;
            }
        }
        if (this.avaTypes.containsKey(normalizedType)) {
            Collection atavList = (Collection)this.avaTypes.get(normalizedType);
            return (Ava)atavList.iterator().next();
        }
        return null;
    }

    @Override
    public Iterator<Ava> iterator() {
        if (this.nbAvas == 1 || this.nbAvas == 0) {
            return new Iterator<Ava>(){
                private boolean hasMoreElement;
                {
                    this.hasMoreElement = Rdn.this.nbAvas == 1;
                }

                @Override
                public boolean hasNext() {
                    return this.hasMoreElement;
                }

                @Override
                public Ava next() {
                    Ava obj = Rdn.this.ava;
                    this.hasMoreElement = false;
                    return obj;
                }

                @Override
                public void remove() {
                }
            };
        }
        return this.avas.iterator();
    }

    public Rdn clone() {
        try {
            Rdn rdn = (Rdn)super.clone();
            rdn.normalized = this.normalized;
            switch (rdn.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    rdn.ava = this.ava.clone();
                    rdn.avaTypes = this.avaTypes;
                    break;
                }
                default: {
                    rdn.avaTypes = new MultiValueMap();
                    rdn.avas = new ArrayList<Ava>();
                    for (Ava currentAva : this.avas) {
                        rdn.avas.add(currentAva.clone());
                        rdn.avaTypes.put(currentAva.getNormType(), currentAva);
                    }
                }
            }
            return rdn;
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Assertion failure");
        }
    }

    public String getName() {
        return this.upName;
    }

    public String getNormName() {
        return this.normName == null ? "" : this.normName;
    }

    void setUpName(String upName) {
        this.upName = upName;
    }

    public Ava getAva() {
        switch (this.nbAvas) {
            case 0: {
                return null;
            }
            case 1: {
                return this.ava;
            }
        }
        return this.avas.get(0).clone();
    }

    public String getType() {
        switch (this.nbAvas) {
            case 0: {
                return null;
            }
            case 1: {
                return this.ava.getType();
            }
        }
        return this.avas.get(0).getType();
    }

    public String getNormType() {
        switch (this.nbAvas) {
            case 0: {
                return null;
            }
            case 1: {
                return this.ava.getNormType();
            }
        }
        return this.avas.get(0).getNormType();
    }

    public Value<?> getValue() {
        switch (this.nbAvas) {
            case 0: {
                return null;
            }
            case 1: {
                return this.ava.getValue();
            }
        }
        return this.avas.get(0).getValue();
    }

    public Value<?> getNormValue() {
        switch (this.nbAvas) {
            case 0: {
                return null;
            }
            case 1: {
                return this.ava.getNormValue();
            }
        }
        return this.avas.get(0).getNormValue();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Rdn)) {
            return false;
        }
        Rdn rdn = (Rdn)that;
        if (this.normName.equals(rdn.normName)) {
            return true;
        }
        if (this.normName.equals(rdn.normName)) {
            return true;
        }
        if (rdn.nbAvas != this.nbAvas) {
            return false;
        }
        switch (this.nbAvas) {
            case 0: {
                return true;
            }
            case 1: {
                return this.ava.equals(rdn.ava);
            }
        }
        Iterator<Ava> localIterator = this.avas.iterator();
        while (localIterator.hasNext()) {
            Iterator<Ava> paramIterator = rdn.avas.iterator();
            Ava localAva = localIterator.next();
            boolean equals = false;
            while (paramIterator.hasNext()) {
                Ava paramAva = paramIterator.next();
                if (!localAva.equals(paramAva)) continue;
                equals = true;
                break;
            }
            if (equals) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.nbAvas;
    }

    public static Object unescapeValue(String value) throws IllegalArgumentException {
        if (Strings.isEmpty(value)) {
            return "";
        }
        char[] chars = value.toCharArray();
        if (chars[0] == '\"' && chars[chars.length - 1] == '\"') {
            return value;
        }
        if (chars[0] == '#') {
            if (chars.length == 1) {
                return StringConstants.EMPTY_BYTES;
            }
            if (chars.length % 2 != 1) {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_04213, new Object[0]));
            }
            byte[] hexValue = new byte[(chars.length - 1) / 2];
            int pos = 0;
            for (int i = 1; i < chars.length; i += 2) {
                if (!Chars.isHex(chars, i) || !Chars.isHex(chars, i + 1)) {
                    throw new IllegalArgumentException(I18n.err(I18n.ERR_04214, new Object[0]));
                }
                hexValue[pos++] = Hex.getHexValue(chars[i], chars[i + 1]);
            }
            return hexValue;
        }
        boolean escaped = false;
        boolean isHex = false;
        int pair = -1;
        int pos = 0;
        byte[] bytes = new byte[chars.length * 6];
        block10: for (int i = 0; i < chars.length; ++i) {
            if (escaped) {
                escaped = false;
                switch (chars[i]) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '\\': {
                        bytes[pos++] = (byte)chars[i];
                        break;
                    }
                    default: {
                        if (!Chars.isHex(chars, i)) continue block10;
                        isHex = true;
                        pair = (byte)(Hex.getHexValue(chars[i]) << 4);
                        break;
                    }
                }
                continue;
            }
            if (isHex) {
                if (!Chars.isHex(chars, i)) continue;
                pair = (byte)(pair + Hex.getHexValue(chars[i]));
                bytes[pos++] = pair;
                isHex = false;
                continue;
            }
            switch (chars[i]) {
                case '\\': {
                    escaped = true;
                    continue block10;
                }
                case '\"': 
                case '#': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '>': {
                    if (i != 0) {
                        bytes[pos++] = 35;
                        continue block10;
                    }
                }
                case '=': {
                    throw new IllegalArgumentException(I18n.err(I18n.ERR_04215, new Object[0]));
                }
                case ' ': {
                    if (i == 0 || i == chars.length - 1) {
                        throw new IllegalArgumentException(I18n.err(I18n.ERR_04215, new Object[0]));
                    }
                    bytes[pos++] = 32;
                    continue block10;
                }
                default: {
                    if (chars[i] >= '\u0000' && chars[i] < '\u0080') {
                        bytes[pos++] = (byte)chars[i];
                        continue block10;
                    }
                    byte[] result = Unicode.charToBytes(chars[i]);
                    System.arraycopy(result, 0, bytes, pos, result.length);
                    pos += result.length;
                }
            }
        }
        return Strings.utf8ToString(bytes, pos);
    }

    public static String escapeValue(String value) {
        if (Strings.isEmpty(value)) {
            return "";
        }
        byte[] bytes = Strings.getBytesUtf8(value);
        byte[] newBytes = new byte[bytes.length * 3];
        int pos = 0;
        block8: for (int i = 0; i < bytes.length; ++i) {
            if ((bytes[i] & 0x80) != 0) {
                newBytes[pos++] = 92;
                newBytes[pos++] = (byte)Strings.dumpHex((byte)((bytes[i] & 0xF0) >> 4));
                newBytes[pos++] = (byte)Strings.dumpHex((byte)(bytes[i] & 0xF));
                continue;
            }
            switch (bytes[i]) {
                case 32: {
                    if (i > 0 && i < bytes.length - 1) {
                        newBytes[pos++] = bytes[i];
                        continue block8;
                    }
                    newBytes[pos++] = 92;
                    newBytes[pos++] = bytes[i];
                    continue block8;
                }
                case 35: {
                    if (i != 0) {
                        newBytes[pos++] = bytes[i];
                        continue block8;
                    }
                    newBytes[pos++] = 92;
                    newBytes[pos++] = bytes[i];
                    continue block8;
                }
                case 34: 
                case 43: 
                case 44: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 92: {
                    newBytes[pos++] = 92;
                    newBytes[pos++] = bytes[i];
                    continue block8;
                }
                case 127: {
                    newBytes[pos++] = 92;
                    newBytes[pos++] = 55;
                    newBytes[pos++] = 70;
                    continue block8;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    newBytes[pos++] = 92;
                    newBytes[pos++] = 48;
                    newBytes[pos++] = (byte)Strings.dumpHex((byte)(bytes[i] & 0xF));
                    continue block8;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    newBytes[pos++] = 92;
                    newBytes[pos++] = 49;
                    newBytes[pos++] = (byte)Strings.dumpHex((byte)(bytes[i] & 0xF));
                    continue block8;
                }
                default: {
                    newBytes[pos++] = bytes[i];
                }
            }
        }
        return new String(newBytes, 0, pos);
    }

    public static String escapeValue(byte[] attrValue) {
        if (Strings.isEmpty(attrValue)) {
            return "";
        }
        String value = Strings.utf8ToString(attrValue);
        return Rdn.escapeValue(value);
    }

    public boolean isSchemaAware() {
        return this.schemaManager != null;
    }

    public static boolean isValid(String dn) {
        Rdn rdn = new Rdn();
        try {
            Rdn.parse(dn, rdn);
            return true;
        }
        catch (LdapInvalidDnException e) {
            return false;
        }
    }

    private static void parse(String dn, Rdn rdn) throws LdapInvalidDnException {
        try {
            FastDnParser.parseRdn(dn, rdn);
        }
        catch (TooComplexException e) {
            rdn.clear();
            new ComplexDnParser().parseRdn(dn, rdn);
        }
    }

    public int hashCode() {
        if (this.h == 0) {
            this.h = 37;
            switch (this.nbAvas) {
                case 0: {
                    break;
                }
                case 1: {
                    this.h = this.h * 17 + this.ava.hashCode();
                    break;
                }
                default: {
                    for (Ava ata : this.avas) {
                        this.h = this.h * 17 + ata.hashCode();
                    }
                }
            }
        }
        return this.h;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.nbAvas);
        out.writeUTF(this.upName);
        if (this.upName.equals(this.normName)) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.normName);
        }
        switch (this.nbAvas) {
            case 0: {
                break;
            }
            case 1: {
                this.ava.writeExternal(out);
                break;
            }
            default: {
                for (Ava localAva : this.avas) {
                    localAva.writeExternal(out);
                }
            }
        }
        out.writeInt(this.h);
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nbAvas = in.readInt();
        this.upName = in.readUTF();
        this.normName = in.readUTF();
        if (Strings.isEmpty(this.normName)) {
            this.normName = this.upName;
        }
        switch (this.nbAvas) {
            case 0: {
                this.ava = null;
                break;
            }
            case 1: {
                this.ava = new Ava(this.schemaManager);
                this.ava.readExternal(in);
                this.avaType = this.ava.getNormType();
                break;
            }
            default: {
                this.avas = new ArrayList<Ava>();
                this.avaTypes = new MultiValueMap();
                for (int i = 0; i < this.nbAvas; ++i) {
                    Ava ava = new Ava(this.schemaManager);
                    ava.readExternal(in);
                    this.avas.add(ava);
                    this.avaTypes.put(ava.getNormType(), ava);
                }
                this.ava = null;
                this.avaType = null;
            }
        }
        this.h = in.readInt();
    }

    @Override
    public int compareTo(Rdn arg0) {
        return 0;
    }

    public String toString() {
        return this.upName == null ? "" : this.upName;
    }
}

