/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.search.subentries;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.tlv.BerValue;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.ControlDecorator;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.codec.controls.search.subentries.SubentriesContainer;
import org.apache.directory.shared.ldap.model.message.controls.Subentries;
import org.apache.directory.shared.ldap.model.message.controls.SubentriesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubentriesDecorator
extends ControlDecorator<Subentries>
implements Subentries {
    private static final Asn1Decoder decoder = new Asn1Decoder();

    public SubentriesDecorator(LdapApiService codec) {
        this(codec, new SubentriesImpl());
    }

    public SubentriesDecorator(LdapApiService codec, Subentries control) {
        super(codec, control);
    }

    @Override
    public int computeLength() {
        return 3;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        BerValue.encode(buffer, this.isVisible());
        return buffer;
    }

    @Override
    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                BerValue.encode(buffer, this.isVisible());
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    @Override
    public boolean isVisible() {
        return ((Subentries)this.getDecorated()).isVisible();
    }

    @Override
    public void setVisibility(boolean visibility) {
        ((Subentries)this.getDecorated()).setVisibility(visibility);
    }

    @Override
    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(controlBytes);
        SubentriesContainer container = new SubentriesContainer(this);
        decoder.decode(bb, container);
        return this;
    }
}

