/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.ber.tlv;

import org.apache.directory.shared.asn1.ber.tlv.BerValue;
import org.apache.directory.shared.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BooleanDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(BooleanDecoder.class);

    public static boolean parse(BerValue value) throws BooleanDecoderException {
        byte[] bytes = value.getData();
        if (Strings.isEmpty(bytes)) {
            throw new BooleanDecoderException(I18n.err(I18n.ERR_00034_0_BYTES_LONG_BOOLEAN, new Object[0]));
        }
        if (bytes.length != 1) {
            throw new BooleanDecoderException(I18n.err(I18n.ERR_00035_N_BYTES_LONG_BOOLEAN, new Object[0]));
        }
        if (bytes[0] != 0 && bytes[0] != -1) {
            LOG.warn("A boolean must be encoded with a 0x00 or a 0xFF value");
        }
        return bytes[0] != 0;
    }
}

