/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.registries.helper;

import java.util.List;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.LdapSyntax;
import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.model.schema.registries.Registries;
import org.apache.directory.shared.ldap.model.schema.syntaxCheckers.OctetStringSyntaxChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapSyntaxHelper {
    private static final Logger LOG = LoggerFactory.getLogger(LdapSyntaxHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToRegistries(LdapSyntax ldapSyntax, List<Throwable> errors, Registries registries) throws LdapException {
        block7: {
            if (registries != null) {
                try {
                    ldapSyntax.unlock();
                    if (registries == null) break block7;
                    SyntaxChecker syntaxChecker = null;
                    try {
                        syntaxChecker = (SyntaxChecker)registries.getSyntaxCheckerRegistry().lookup(ldapSyntax.getOid());
                    }
                    catch (LdapException ne) {
                        syntaxChecker = new OctetStringSyntaxChecker(ldapSyntax.getOid());
                    }
                    if (syntaxChecker != null) {
                        registries.addReference(ldapSyntax, syntaxChecker);
                        ldapSyntax.setSyntaxChecker(syntaxChecker);
                    }
                }
                finally {
                    ldapSyntax.lock();
                }
            }
        }
    }

    public static void removeFromRegistries(LdapSyntax ldapSyntax, List<Throwable> errors, Registries registries) throws LdapException {
        if (registries != null && ldapSyntax.getSyntaxChecker() != null) {
            registries.delReference(ldapSyntax, ldapSyntax.getSyntaxChecker());
        }
    }
}

