/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.searchRequest.filter;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.BerValue;
import org.apache.directory.shared.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.shared.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.shared.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreMatchingRuleDnAttributes
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreMatchingRuleDnAttributes.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreMatchingRuleDnAttributes() {
        super("Store matchingRuleAssertion dnAttributes");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)searchRequest.getTerminalFilter();
        BerValue value = tlv.getValue();
        try {
            extensibleMatchFilter.setDnAttributes(BooleanDecoder.parse(value));
        }
        catch (BooleanDecoderException bde) {
            LOG.error(I18n.err(I18n.ERR_04110, Strings.dumpBytes(value.getData()), bde.getMessage()));
            throw new DecoderException(bde.getMessage());
        }
        if (IS_DEBUG) {
            LOG.debug("Dn Attributes : {}", extensibleMatchFilter.isDnAttributes());
        }
        searchRequest.unstackFilters(container);
    }
}

