/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.searchRequest.filter;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.shared.ldap.codec.search.AndFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitAndFilter
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitAndFilter.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public InitAndFilter() {
        super("Initialize AND filter");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_04006, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        AndFilter andFilter = new AndFilter(container.getTlvId());
        searchRequestDecorator.addCurrentFilter(andFilter);
        if (IS_DEBUG) {
            LOG.debug("Initialize AND filter");
        }
    }
}

