/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.SingletonIndexCursor;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.AllEntriesCursor;
import org.apache.directory.server.xdbm.search.impl.DescendantCursor;
import org.apache.directory.server.xdbm.search.impl.SubtreeScopeEvaluator;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubtreeScopeCursor<ID extends Comparable<ID>>
extends AbstractIndexCursor<ID, Entry, ID> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger("CURSOR");
    private static final String UNSUPPORTED_MSG = I18n.err(I18n.ERR_719, new Object[0]);
    private final Store<Entry, ID> db;
    private final SubtreeScopeEvaluator<Entry, ID> evaluator;
    private final IndexCursor<ID, Entry, ID> scopeCursor;
    private final IndexCursor<ID, Entry, ID> dereferencedCursor;
    private IndexCursor<ID, Entry, ID> cursor;
    private ID contextEntryId;

    public SubtreeScopeCursor(Store<Entry, ID> db, SubtreeScopeEvaluator<Entry, ID> evaluator) throws Exception {
        LOG_CURSOR.debug("Creating SubtreeScopeCursor {}", this);
        this.db = db;
        this.evaluator = evaluator;
        if (evaluator.getBaseId() == this.getContextEntryId()) {
            this.scopeCursor = new AllEntriesCursor<ID>(db);
        } else {
            ID baseId = evaluator.getBaseId();
            ParentIdAndRdn<ID> parentIdAndRdn = db.getRdnIndex().reverseLookup(baseId);
            ForwardIndexEntry<ParentIdAndRdn<ID>, ID> indexEntry = new ForwardIndexEntry<ParentIdAndRdn<ID>, ID>();
            indexEntry.setId(baseId);
            indexEntry.setKey(parentIdAndRdn);
            SingletonIndexCursor cursor = new SingletonIndexCursor(indexEntry);
            ID parentId = parentIdAndRdn.getParentId();
            this.scopeCursor = new DescendantCursor<ID>(db, baseId, parentId, cursor);
        }
        this.dereferencedCursor = evaluator.isDereferencing() ? db.getSubAliasIndex().forwardCursor(evaluator.getBaseId()) : null;
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    private ID getContextEntryId() throws Exception {
        if (this.contextEntryId == null) {
            try {
                this.contextEntryId = this.db.getEntryId(((Partition)((Object)this.db)).getSuffixDn());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.contextEntryId == null) {
            return this.db.getDefaultId();
        }
        return this.contextEntryId;
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.cursor = this.scopeCursor;
        this.cursor.beforeFirst();
        this.setAvailable(false);
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.cursor = this.evaluator.isDereferencing() ? this.dereferencedCursor : this.scopeCursor;
        this.cursor.afterLast();
        this.setAvailable(false);
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.cursor == null) {
            this.afterLast();
        }
        if (this.cursor == this.scopeCursor) {
            if (this.evaluator.isDereferencing()) {
                do {
                    this.checkNotClosed("previous()");
                    this.setAvailable(this.cursor.previous());
                } while ((!this.available() || this.db.getAliasIndex().reverseLookup(((IndexEntry)this.cursor.get()).getId()) != null) && this.available());
            } else {
                this.setAvailable(this.cursor.previous());
            }
            return this.available();
        }
        this.setAvailable(this.cursor.previous());
        if (!this.available()) {
            this.cursor = this.scopeCursor;
            this.cursor.afterLast();
            do {
                this.checkNotClosed("previous()");
                this.setAvailable(this.cursor.previous());
            } while ((!this.available() || this.db.getAliasIndex().reverseLookup(((IndexEntry)this.cursor.get()).getId()) != null) && this.available());
            return this.available();
        }
        return true;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.cursor == null) {
            this.beforeFirst();
        }
        if (this.evaluator.isDereferencing()) {
            do {
                this.checkNotClosed("next()");
                this.setAvailable(this.cursor.next());
            } while ((!this.available() || this.db.getAliasIndex().reverseLookup(((IndexEntry)this.cursor.get()).getId()) != null) && this.available());
        } else {
            this.setAvailable(this.cursor.next());
        }
        if (this.cursor == this.dereferencedCursor) {
            return this.available();
        }
        if (!this.available()) {
            if (this.dereferencedCursor != null) {
                this.cursor = this.dereferencedCursor;
                this.cursor.beforeFirst();
                return this.setAvailable(this.cursor.next());
            }
            return false;
        }
        return true;
    }

    @Override
    public IndexEntry<ID, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.available()) {
            return (IndexEntry)this.cursor.get();
        }
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_708, new Object[0]));
    }

    @Override
    public void close() throws Exception {
        LOG_CURSOR.debug("Closing SubtreeScopeCursor {}", this);
        if (this.dereferencedCursor != null) {
            this.dereferencedCursor.close();
        }
        if (this.scopeCursor != null) {
            this.scopeCursor.close();
        }
        if (this.cursor != null) {
            this.cursor.close();
        }
        super.close();
    }

    @Override
    public void close(Exception cause) throws Exception {
        LOG_CURSOR.debug("Closing SubtreeScopeCursor {}", this);
        if (this.dereferencedCursor != null) {
            this.dereferencedCursor.close(cause);
        }
        if (this.scopeCursor != null) {
            this.scopeCursor.close(cause);
        }
        if (this.cursor != null) {
            this.cursor.close(cause);
        }
        super.close(cause);
    }
}

