/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.filter.SubstringNode;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.Normalizer;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.normalizers.NoOpNormalizer;

public class SubstringEvaluator<ID extends Comparable<ID>>
implements Evaluator<SubstringNode, Entry, ID> {
    private final Store<Entry, ID> db;
    private final SchemaManager schemaManager;
    private final SubstringNode node;
    private final Pattern regex;
    private final AttributeType attributeType;
    private final Normalizer normalizer;
    private final Index<String, Entry, ID> idx;

    public SubstringEvaluator(SubstringNode node, Store<Entry, ID> db, SchemaManager schemaManager) throws Exception {
        this.db = db;
        this.node = node;
        this.schemaManager = schemaManager;
        this.attributeType = node.getAttributeType();
        MatchingRule rule = this.attributeType.getSubstring();
        if (rule == null) {
            rule = this.attributeType.getEquality();
        }
        this.normalizer = rule != null ? rule.getNormalizer() : new NoOpNormalizer(this.attributeType.getSyntaxOid());
        this.regex = this.attributeType.getSyntax().isHumanReadable() ? node.getRegex(this.normalizer) : null;
        this.idx = db.hasIndexOn(this.attributeType) ? db.getIndex(this.attributeType) : null;
    }

    @Override
    public boolean evaluate(IndexEntry<?, ID> indexEntry) throws Exception {
        if (this.idx == null || !this.idx.hasReverse()) {
            return this.evaluateWithoutIndex(indexEntry);
        }
        return this.evaluateWithIndex((ID)indexEntry);
    }

    public boolean evaluateId(ID id) throws Exception {
        if (this.idx == null) {
            return this.evaluateWithoutIndex(id);
        }
        return this.evaluateWithIndex(id);
    }

    @Override
    public boolean evaluateEntry(Entry entry) throws Exception {
        if (this.idx == null) {
            return this.evaluateWithoutIndex(entry);
        }
        return this.evaluateWithIndex();
    }

    public Pattern getPattern() {
        return this.regex;
    }

    @Override
    public SubstringNode getExpression() {
        return this.node;
    }

    private boolean evaluateWithIndex(IndexEntry<?, ID> indexEntry) throws Exception {
        IndexCursor<String, Entry, ID> entries = this.idx.reverseCursor(indexEntry.getId());
        while (entries.next()) {
            IndexEntry rec = (IndexEntry)entries.get();
            if (!this.regex.matcher((CharSequence)rec.getKey()).matches()) continue;
            entries.close();
            return true;
        }
        entries.close();
        return false;
    }

    private boolean evaluateWithIndex() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_721, new Object[0]));
    }

    private boolean evaluateWithIndex(ID id) throws Exception {
        IndexCursor<String, Entry, ID> entries = this.idx.reverseCursor(id);
        while (entries.next()) {
            IndexEntry rec = (IndexEntry)entries.get();
            if (!this.regex.matcher((CharSequence)rec.getKey()).matches()) continue;
            entries.close();
            return true;
        }
        entries.close();
        return false;
    }

    private boolean evaluateWithoutIndex(ID id) throws Exception {
        return this.evaluateWithoutIndex(this.db.lookup(id));
    }

    private boolean evaluateWithoutIndex(Entry entry) throws Exception {
        Attribute attr = entry.get(this.attributeType);
        if (attr != null) {
            for (Value value : attr) {
                String strValue = (String)value.getNormValue();
                if (!this.regex.matcher(strValue).matches()) continue;
                return true;
            }
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.attributeType)) {
            Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.attributeType);
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = entry.get(descendant);
                if (null == attr) continue;
                for (Value value : attr) {
                    String strValue = (String)value.getNormValue();
                    if (!this.regex.matcher(strValue).matches()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean evaluateWithoutIndex(IndexEntry<String, ID> indexEntry) throws Exception {
        Attribute attr;
        Entry entry = indexEntry.getEntry();
        if (null == entry) {
            entry = this.db.lookup((Comparable)indexEntry.getId());
            indexEntry.setEntry(entry);
        }
        if ((attr = entry.get(this.attributeType)) != null) {
            if (attr.isHumanReadable()) {
                for (Value value : attr) {
                    String strValue = (String)value.getNormValue();
                    if (!this.regex.matcher(strValue).matches()) continue;
                    indexEntry.setKey(strValue);
                    return true;
                }
            } else {
                for (Value value : attr) {
                    byte[] byteValue = (byte[])value.getNormValue();
                }
            }
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.attributeType)) {
            Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.attributeType);
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = entry.get(descendant);
                if (null == attr) continue;
                for (Value value : attr) {
                    String strValue = (String)value.getNormValue();
                    if (!this.regex.matcher(strValue).matches()) continue;
                    indexEntry.setKey(strValue);
                    return true;
                }
            }
        }
        return false;
    }
}

