/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.impl.avl;

import java.util.Comparator;
import org.apache.directory.server.core.avltree.AvlSingletonOrOrderedSetCursor;
import org.apache.directory.server.core.avltree.AvlTree;
import org.apache.directory.server.core.avltree.AvlTreeCursor;
import org.apache.directory.server.core.avltree.AvlTreeMap;
import org.apache.directory.server.core.avltree.AvlTreeMapImpl;
import org.apache.directory.server.core.avltree.AvlTreeMapNoDupsWrapperCursor;
import org.apache.directory.server.core.avltree.KeyTupleAvlCursor;
import org.apache.directory.server.core.avltree.LinkedAvlMapNode;
import org.apache.directory.server.core.avltree.SingletonOrOrderedSet;
import org.apache.directory.server.xdbm.AbstractTable;
import org.apache.directory.server.xdbm.impl.avl.AvlTableDupsCursor;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.model.cursor.SingletonCursor;
import org.apache.directory.shared.ldap.model.cursor.Tuple;

public class AvlTable<K, V>
extends AbstractTable<K, V> {
    private final AvlTreeMap<K, V> avl;
    private final Comparator<Tuple<K, V>> keyOnlytupleComparator;

    public AvlTable(String name, final Comparator<K> keyComparator, Comparator<V> valueComparator, boolean dupsEnabled) {
        super(null, name, keyComparator, valueComparator);
        this.avl = new AvlTreeMapImpl<K, V>(keyComparator, valueComparator, dupsEnabled);
        this.allowsDuplicates = this.avl.isDupsAllowed();
        this.keyOnlytupleComparator = new Comparator<Tuple<K, V>>(){

            @Override
            public int compare(Tuple<K, V> t0, Tuple<K, V> t1) {
                return keyComparator.compare(t0.getKey(), t1.getKey());
            }
        };
    }

    @Override
    public void close() throws Exception {
        ((AvlTreeMapImpl)this.avl).removeAll();
    }

    @Override
    public int count(K key) throws Exception {
        if (key == null) {
            return 0;
        }
        LinkedAvlMapNode<K, V> node = this.avl.find(key);
        if (node == null) {
            return 0;
        }
        SingletonOrOrderedSet<V> val = node.getValue();
        if (val.isOrderedSet()) {
            return val.getOrderedSet().getSize();
        }
        return 1;
    }

    @Override
    public V get(K key) throws Exception {
        if (key == null) {
            return null;
        }
        LinkedAvlMapNode<K, V> node = this.avl.find(key);
        if (node == null) {
            return null;
        }
        SingletonOrOrderedSet<V> val = node.getValue();
        if (val.isOrderedSet()) {
            return val.getOrderedSet().getFirst().getKey();
        }
        return val.getSingleton();
    }

    @Override
    public int greaterThanCount(K key) throws Exception {
        return this.avl.getSize();
    }

    @Override
    public boolean has(K key) throws Exception {
        if (key == null) {
            return false;
        }
        return this.avl.find(key) != null;
    }

    @Override
    public boolean has(K key, V value) throws Exception {
        if (key == null) {
            return false;
        }
        return this.avl.find(key, value) != null;
    }

    @Override
    public boolean hasGreaterOrEqual(K key) throws Exception {
        if (key == null) {
            return false;
        }
        return this.avl.findGreaterOrEqual(key) != null;
    }

    @Override
    public boolean hasGreaterOrEqual(K key, V val) throws Exception {
        if (key == null) {
            return false;
        }
        LinkedAvlMapNode<K, V> node = this.avl.findGreaterOrEqual(key);
        if (node == null) {
            return false;
        }
        if (node.getValue().isOrderedSet()) {
            AvlTree<V> values = node.getValue().getOrderedSet();
            return values.findGreaterOrEqual(val) != null;
        }
        return this.valueComparator.compare(node.getValue().getSingleton(), val) >= 0;
    }

    @Override
    public boolean hasLessOrEqual(K key) throws Exception {
        if (key == null) {
            return false;
        }
        return this.avl.findLessOrEqual(key) != null;
    }

    @Override
    public boolean hasLessOrEqual(K key, V val) throws Exception {
        if (key == null) {
            return false;
        }
        LinkedAvlMapNode<K, V> node = this.avl.findLessOrEqual(key);
        if (node == null) {
            return false;
        }
        if (node.getValue().isOrderedSet()) {
            AvlTree<V> values = node.getValue().getOrderedSet();
            return values.findLessOrEqual(val) != null;
        }
        return this.valueComparator.compare(node.getValue().getSingleton(), val) <= 0;
    }

    @Override
    public boolean isDupsEnabled() {
        return this.allowsDuplicates;
    }

    @Override
    public int lessThanCount(K key) throws Exception {
        return this.count;
    }

    @Override
    public void put(K key, V value) throws Exception {
        if (key == null || value == null) {
            return;
        }
        if (this.avl.insert(key, value) == null) {
            ++this.count;
        }
    }

    @Override
    public void remove(K key) throws Exception {
        if (key == null) {
            return;
        }
        SingletonOrOrderedSet<V> value = this.avl.remove(key);
        if (value == null) {
            return;
        }
        this.count = value.isOrderedSet() ? (this.count -= value.getOrderedSet().getSize()) : --this.count;
    }

    @Override
    public void remove(K key, V value) throws Exception {
        if (this.avl.remove(key, value) != null) {
            --this.count;
        }
    }

    @Override
    public Cursor<Tuple<K, V>> cursor() throws Exception {
        if (!this.allowsDuplicates) {
            return new AvlTreeMapNoDupsWrapperCursor<K, V>(new AvlSingletonOrOrderedSetCursor<K, V>(this.avl));
        }
        return new AvlTableDupsCursor(this);
    }

    @Override
    public Cursor<Tuple<K, V>> cursor(K key) throws Exception {
        if (key == null) {
            return new EmptyCursor<Tuple<K, V>>();
        }
        LinkedAvlMapNode<K, V> node = this.avl.find(key);
        if (node == null) {
            return new EmptyCursor<Tuple<K, V>>();
        }
        if (node.getValue().isOrderedSet()) {
            return new KeyTupleAvlCursor<K, V>(node.getValue().getOrderedSet(), key);
        }
        return new SingletonCursor<Tuple<K, V>>(new Tuple<K, V>(key, node.getValue().getSingleton()), this.keyOnlytupleComparator);
    }

    @Override
    public Cursor<V> valueCursor(K key) throws Exception {
        if (key == null) {
            return new EmptyCursor();
        }
        LinkedAvlMapNode<K, V> node = this.avl.find(key);
        if (node == null) {
            return new EmptyCursor();
        }
        if (node.getValue().isOrderedSet()) {
            return new AvlTreeCursor<V>(node.getValue().getOrderedSet());
        }
        return new SingletonCursor<V>(node.getValue().getSingleton(), this.valueComparator);
    }

    AvlTreeMap<K, V> getAvlTreeMap() {
        return this.avl;
    }
}

