/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.shared.ldap.model.schema.AttributeType;

public abstract class AbstractIndex<K, O, ID>
implements Index<K, O, ID> {
    protected String attributeId;
    protected AttributeType attributeType;
    protected int cacheSize = 100;
    protected boolean initialized;
    protected boolean withReverse;

    protected AbstractIndex() {
        this.withReverse = true;
    }

    protected AbstractIndex(boolean withReverse) {
        this.withReverse = withReverse;
    }

    protected AbstractIndex(String attributeId, boolean withReverse) {
        this.attributeId = attributeId;
        this.withReverse = withReverse;
    }

    @Override
    public String getAttributeId() {
        return this.attributeId;
    }

    @Override
    public AttributeType getAttribute() {
        return this.attributeType;
    }

    @Override
    public void setAttributeId(String attributeId) {
        this.protect("attributeId");
        this.attributeId = attributeId;
    }

    @Override
    public boolean isDupsEnabled() {
        return !this.attributeType.isSingleValued();
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public void setCacheSize(int cacheSize) {
        this.protect("cacheSize");
        this.cacheSize = cacheSize;
    }

    protected void protect(String property) {
        if (this.initialized) {
            throw new IllegalStateException(I18n.err(I18n.ERR_575, property));
        }
    }

    @Override
    public boolean hasReverse() {
        return this.withReverse;
    }
}

