/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.shared.ldap.model.cursor.Tuple;
import org.apache.directory.shared.util.exception.NotImplementedException;

public class IndexEnumeration<T>
implements NamingEnumeration<IndexEntry> {
    private final Pattern re;
    private final ForwardIndexEntry tmp = new ForwardIndexEntry();
    private final ForwardIndexEntry returned = new ForwardIndexEntry();
    private final ForwardIndexEntry prefetched = new ForwardIndexEntry();
    private final boolean swapKeyVal;
    private final NamingEnumeration<Tuple> underlying;
    private boolean hasMore = true;

    public IndexEnumeration(NamingEnumeration<Tuple> list) throws NamingException {
        this(list, false, null);
    }

    public IndexEnumeration(NamingEnumeration<Tuple> list, boolean swapKeyVal) throws NamingException {
        this(list, swapKeyVal, null);
    }

    public IndexEnumeration(NamingEnumeration<Tuple> list, boolean swapKeyVal, Pattern regex) throws NamingException {
        this.re = regex;
        this.underlying = list;
        this.swapKeyVal = swapKeyVal;
        if (!this.underlying.hasMore()) {
            this.hasMore = false;
            return;
        }
        this.prefetch();
    }

    @Override
    public IndexEntry next() throws NamingException {
        this.returned.copy(this.prefetched);
        this.prefetch();
        return this.returned;
    }

    @Override
    public IndexEntry nextElement() {
        try {
            return this.next();
        }
        catch (NamingException ne) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMore;
    }

    @Override
    public void close() throws NamingException {
        this.hasMore = false;
        this.underlying.close();
    }

    private void prefetch() throws NamingException {
        while (this.underlying.hasMore()) {
            Tuple tuple = this.underlying.next();
            if (this.swapKeyVal) {
                throw new NotImplementedException();
            }
            this.tmp.setTuple(tuple, null);
            if (null != this.re && !this.re.matcher((String)this.tmp.getKey()).matches()) continue;
            this.prefetched.copy(this.tmp);
            return;
        }
        this.hasMore = false;
    }
}

