/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import java.net.SocketAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.authn.AbstractAuthenticator;
import org.apache.directory.server.core.authn.PasswordUtil;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Base64;
import org.apache.directory.shared.util.StringConstants;
import org.apache.directory.shared.util.Strings;
import org.apache.directory.shared.util.UnixCrypt;
import org.apache.mina.core.session.IoSession;

public class SimpleAuthenticator
extends AbstractAuthenticator {
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private final LRUMap credentialCache;
    private static final int DEFAULT_CACHE_SIZE = 100;

    public SimpleAuthenticator() {
        super(AuthenticationLevel.SIMPLE);
        this.credentialCache = new LRUMap(100);
    }

    public SimpleAuthenticator(int cacheSize) {
        super(AuthenticationLevel.SIMPLE);
        this.credentialCache = new LRUMap(cacheSize > 0 ? cacheSize : 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapPrincipal getStoredPassword(BindOperationContext bindContext) throws LdapException {
        LdapPrincipal principal = null;
        if (!this.getDirectoryService().isPwdPolicyEnabled()) {
            LRUMap lRUMap = this.credentialCache;
            synchronized (lRUMap) {
                principal = (LdapPrincipal)this.credentialCache.get(bindContext.getDn().getNormName());
            }
        }
        if (principal == null) {
            byte[] storedPassword = this.lookupUserPassword(bindContext);
            if (storedPassword == null) {
                storedPassword = ArrayUtils.EMPTY_BYTE_ARRAY;
            }
            principal = new LdapPrincipal(this.getDirectoryService().getSchemaManager(), bindContext.getDn(), AuthenticationLevel.SIMPLE, storedPassword);
            if (!this.getDirectoryService().isPwdPolicyEnabled()) {
                LRUMap lRUMap = this.credentialCache;
                synchronized (lRUMap) {
                    this.credentialCache.put(bindContext.getDn().getNormName(), principal);
                }
            }
        }
        return principal;
    }

    @Override
    public LdapPrincipal authenticate(BindOperationContext bindContext) throws LdapException {
        byte[] storedPassword;
        if (IS_DEBUG) {
            LOG.debug("Authenticating {}", bindContext.getDn());
        }
        byte[] credentials = bindContext.getCredentials();
        LdapPrincipal principal = this.getStoredPassword(bindContext);
        IoSession session = bindContext.getIoSession();
        if (session != null) {
            SocketAddress clientAddress = session.getRemoteAddress();
            principal.setClientAddress(clientAddress);
            SocketAddress serverAddress = session.getServiceAddress();
            principal.setServerAddress(serverAddress);
        }
        if (PasswordUtil.compareCredentials(credentials, storedPassword = principal.getUserPassword())) {
            if (IS_DEBUG) {
                LOG.debug("{} Authenticated", bindContext.getDn());
            }
            return principal;
        }
        String message = I18n.err(I18n.ERR_230, bindContext.getDn().getName());
        LOG.info(message);
        throw new LdapAuthenticationException(message);
    }

    private byte[] lookupUserPassword(BindOperationContext bindContext) throws LdapException {
        Entry userEntry;
        try {
            LookupOperationContext lookupContext = new LookupOperationContext(this.getDirectoryService().getAdminSession(), bindContext.getDn());
            lookupContext.addAttrsId("*");
            lookupContext.addAttrsId("+");
            userEntry = this.getDirectoryService().getPartitionNexus().lookup(lookupContext);
            if (userEntry == null) {
                Dn dn = bindContext.getDn();
                String upDn = dn == null ? "" : dn.getName();
                throw new LdapAuthenticationException(I18n.err(I18n.ERR_231, upDn));
            }
        }
        catch (Exception cause) {
            LOG.error(I18n.err(I18n.ERR_6, cause.getLocalizedMessage()));
            LdapAuthenticationException e = new LdapAuthenticationException(cause.getLocalizedMessage());
            e.initCause(e);
            throw e;
        }
        this.checkPwdPolicy(userEntry);
        Attribute userPasswordAttr = userEntry.get("userPassword");
        bindContext.setEntry(new ClonedServerEntry(userEntry));
        if (userPasswordAttr == null) {
            return StringConstants.EMPTY_BYTES;
        }
        Value<?> userPassword = userPasswordAttr.get();
        return userPassword.getBytes();
    }

    protected String getAlgorithmForHashedPassword(byte[] password) throws IllegalArgumentException {
        String result = null;
        String sPassword = Strings.utf8ToString(password);
        int rightParen = sPassword.indexOf(125);
        if (sPassword.length() > 2 && sPassword.charAt(0) == '{' && rightParen > -1) {
            String algorithm = sPassword.substring(1, rightParen);
            if (LdapSecurityConstants.HASH_METHOD_CRYPT.getName().equalsIgnoreCase(algorithm)) {
                return algorithm;
            }
            try {
                MessageDigest.getInstance(algorithm);
                result = algorithm;
            }
            catch (NoSuchAlgorithmException e) {
                LOG.warn("Unknown message digest algorithm in password: " + algorithm, e);
            }
        }
        return result;
    }

    protected String createDigestedPassword(String algorithm, byte[] password) throws IllegalArgumentException {
        try {
            if (LdapSecurityConstants.HASH_METHOD_CRYPT.getName().equalsIgnoreCase(algorithm)) {
                String saltWithCrypted = UnixCrypt.crypt(Strings.utf8ToString(password), "");
                String crypted = saltWithCrypted.substring(2);
                return '{' + algorithm + '}' + Arrays.toString(Strings.getBytesUtf8(crypted));
            }
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] fingerPrint = digest.digest(password);
            char[] encoded = Base64.encode(fingerPrint);
            return '{' + algorithm + '}' + new String(encoded);
        }
        catch (NoSuchAlgorithmException nsae) {
            LOG.error(I18n.err(I18n.ERR_7, algorithm));
            throw new IllegalArgumentException(nsae.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateCache(Dn bindDn) {
        LRUMap lRUMap = this.credentialCache;
        synchronized (lRUMap) {
            this.credentialCache.remove(bindDn.getNormName());
        }
    }
}

