/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;

public class ClonedServerEntry
implements Entry {
    protected Entry originalEntry;
    protected Entry clonedEntry;

    public ClonedServerEntry() {
    }

    public ClonedServerEntry(Entry originalEntry) {
        this.originalEntry = originalEntry;
        this.clonedEntry = originalEntry.clone();
    }

    public Entry getOriginalEntry() {
        return this.originalEntry;
    }

    public Entry getClonedEntry() {
        return this.clonedEntry;
    }

    @Override
    public void add(AttributeType attributeType, byte[] ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    @Override
    public void add(AttributeType attributeType, String ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    @Override
    public void add(AttributeType attributeType, Value<?> ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    @Override
    public void add(String upId, AttributeType attributeType, byte[] ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    @Override
    public void add(String upId, AttributeType attributeType, String ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    @Override
    public void add(String upId, AttributeType attributeType, Value<?> ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    @Override
    public boolean contains(AttributeType attributeType, byte[] ... values) {
        return this.clonedEntry.contains(attributeType, values);
    }

    @Override
    public boolean contains(AttributeType attributeType, String ... values) {
        return this.clonedEntry.contains(attributeType, values);
    }

    @Override
    public boolean contains(AttributeType attributeType, Value<?> ... values) {
        return this.clonedEntry.contains(attributeType, values);
    }

    @Override
    public boolean containsAttribute(AttributeType attributeType) {
        return this.clonedEntry.containsAttribute(attributeType);
    }

    @Override
    public Attribute get(AttributeType attributeType) {
        return this.clonedEntry.get(attributeType);
    }

    @Override
    public Collection<Attribute> getAttributes() {
        return this.clonedEntry.getAttributes();
    }

    @Override
    public boolean hasObjectClass(Attribute ... objectClasses) {
        return this.clonedEntry.hasObjectClass(objectClasses);
    }

    @Override
    public Attribute put(AttributeType attributeType, byte[] ... values) throws LdapException {
        return this.clonedEntry.put(attributeType, values);
    }

    @Override
    public Attribute put(AttributeType attributeType, String ... values) throws LdapException {
        return this.clonedEntry.put(attributeType, values);
    }

    @Override
    public Attribute put(AttributeType attributeType, Value<?> ... values) throws LdapException {
        return this.clonedEntry.put(attributeType, values);
    }

    @Override
    public Attribute put(String upId, AttributeType attributeType, byte[] ... values) throws LdapException {
        return this.clonedEntry.put(attributeType, values);
    }

    @Override
    public Attribute put(String upId, AttributeType attributeType, String ... values) throws LdapException {
        return this.clonedEntry.put(upId, attributeType, values);
    }

    @Override
    public Attribute put(String upId, AttributeType attributeType, Value<?> ... values) throws LdapException {
        return this.clonedEntry.put(upId, attributeType, values);
    }

    @Override
    public boolean remove(AttributeType attributeType, byte[] ... values) throws LdapException {
        return this.clonedEntry.remove(attributeType, values);
    }

    @Override
    public boolean remove(AttributeType attributeType, String ... values) throws LdapException {
        return this.clonedEntry.remove(attributeType, values);
    }

    @Override
    public boolean remove(AttributeType attributeType, Value<?> ... values) throws LdapException {
        return this.clonedEntry.remove(attributeType, values);
    }

    @Override
    public List<Attribute> remove(Attribute ... attributes) throws LdapException {
        return this.clonedEntry.remove(attributes);
    }

    @Override
    public void removeAttributes(AttributeType ... attributes) {
        this.clonedEntry.removeAttributes(attributes);
    }

    @Override
    public void add(Attribute ... attributes) throws LdapException {
        this.clonedEntry.add(attributes);
    }

    @Override
    public void add(String upId, String ... values) throws LdapException {
        this.clonedEntry.add(upId, values);
    }

    @Override
    public void add(String upId, byte[] ... values) throws LdapException {
        this.clonedEntry.add(upId, values);
    }

    @Override
    public void add(String upId, Value<?> ... values) throws LdapException {
        this.clonedEntry.add(upId, values);
    }

    @Override
    public void clear() {
        this.clonedEntry.clear();
    }

    @Override
    public boolean contains(Attribute ... attributes) {
        return this.clonedEntry.contains(attributes);
    }

    @Override
    public boolean contains(String upId, byte[] ... values) {
        return this.clonedEntry.contains(upId, values);
    }

    @Override
    public boolean contains(String upId, String ... values) {
        return this.clonedEntry.contains(upId, values);
    }

    @Override
    public boolean contains(String upId, Value<?> ... values) {
        return this.clonedEntry.contains(upId, values);
    }

    @Override
    public boolean containsAttribute(String ... attributes) {
        return this.clonedEntry.containsAttribute(attributes);
    }

    @Override
    public Attribute get(String alias) {
        return this.clonedEntry.get(alias);
    }

    @Override
    public Dn getDn() {
        return this.clonedEntry.getDn();
    }

    @Override
    public boolean hasObjectClass(String ... objectClasses) {
        return this.clonedEntry.hasObjectClass(objectClasses);
    }

    @Override
    public boolean isSchemaAware() {
        return this.clonedEntry.isSchemaAware();
    }

    @Override
    public Iterator<Attribute> iterator() {
        return this.clonedEntry.iterator();
    }

    @Override
    public List<Attribute> put(Attribute ... attributes) throws LdapException {
        return this.clonedEntry.put(attributes);
    }

    @Override
    public Attribute put(String upId, byte[] ... values) {
        return this.clonedEntry.put(upId, values);
    }

    @Override
    public Attribute put(String upId, String ... values) {
        return this.clonedEntry.put(upId, values);
    }

    @Override
    public Attribute put(String upId, Value<?> ... values) {
        return this.clonedEntry.put(upId, values);
    }

    @Override
    public boolean remove(String upId, byte[] ... values) throws LdapException {
        return this.clonedEntry.remove(upId, values);
    }

    @Override
    public boolean remove(String upId, String ... values) throws LdapException {
        return this.clonedEntry.remove(upId, values);
    }

    @Override
    public boolean remove(String upId, Value<?> ... values) throws LdapException {
        return this.clonedEntry.remove(upId, values);
    }

    @Override
    public void removeAttributes(String ... attributes) {
        this.clonedEntry.removeAttributes(attributes);
    }

    @Override
    public void setDn(Dn dn) {
        this.clonedEntry.setDn(dn);
    }

    @Override
    public void setDn(String dn) throws LdapInvalidDnException {
        this.clonedEntry.setDn(dn);
    }

    @Override
    public int size() {
        return this.clonedEntry.size();
    }

    public Entry toClientEntry() throws LdapException {
        DefaultEntry clientEntry = new DefaultEntry(this.clonedEntry.getDn());
        for (Attribute clonedEntry : this) {
            Attribute clientAttribute = clonedEntry.clone();
            clientEntry.add(clientAttribute);
        }
        return clientEntry;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new IllegalStateException(I18n.err(I18n.ERR_455, new Object[0]));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new IllegalStateException(I18n.err(I18n.ERR_456, new Object[0]));
    }

    @Override
    public Entry clone() {
        return this.clonedEntry.clone();
    }

    public int hashCode() {
        return 703;
    }

    public boolean equals(Object obj) {
        Entry other;
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClonedServerEntry) {
            other = ((ClonedServerEntry)obj).getClonedEntry();
        } else if (obj instanceof Entry) {
            other = (Entry)obj;
        } else {
            return false;
        }
        if (this.clonedEntry == null) {
            return other == null;
        }
        return this.clonedEntry.equals(other);
    }

    public String toString() {
        return this.clonedEntry.toString();
    }
}

