/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.comparators;

import org.apache.directory.shared.ldap.model.schema.LdapComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsnSidComparator
extends LdapComparator<String> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(CsnSidComparator.class);

    public CsnSidComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(String sidStr1, String sidStr2) {
        LOG.debug("comparing CSN SID objects '{}' with '{}'", (Object)sidStr1, (Object)sidStr2);
        if (sidStr1 == null) {
            return sidStr2 == null ? 0 : -1;
        }
        if (sidStr2 == null) {
            return 1;
        }
        int sid1 = 0;
        int sid2 = 0;
        try {
            sid1 = Integer.parseInt(sidStr1, 16);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
        try {
            sid2 = Integer.parseInt(sidStr2, 16);
        }
        catch (NumberFormatException nfe) {
            return 1;
        }
        if (sid1 > sid2) {
            return 1;
        }
        if (sid2 > sid1) {
            return -1;
        }
        return 0;
    }
}

