/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.filter;

import java.text.ParseException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.AttributeUtils;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.filter.AndNode;
import org.apache.directory.shared.ldap.model.filter.ApproximateNode;
import org.apache.directory.shared.ldap.model.filter.BranchNode;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.model.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.model.filter.LessEqNode;
import org.apache.directory.shared.ldap.model.filter.NotNode;
import org.apache.directory.shared.ldap.model.filter.OrNode;
import org.apache.directory.shared.ldap.model.filter.PresenceNode;
import org.apache.directory.shared.ldap.model.filter.SubstringNode;
import org.apache.directory.shared.ldap.model.filter.UndefinedNode;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.util.Chars;
import org.apache.directory.shared.util.Hex;
import org.apache.directory.shared.util.Position;
import org.apache.directory.shared.util.Strings;
import org.apache.directory.shared.util.Unicode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterParser {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ExprNode parseExtensible(SchemaManager schemaManager, String attribute, byte[] filter, Position pos) throws LdapException, ParseException {
        ExtensibleNode node = null;
        if (schemaManager != null) {
            AttributeType attributeType = schemaManager.getAttributeType(attribute);
            if (attributeType == null) return UndefinedNode.UNDEFINED_NODE;
            node = new ExtensibleNode(attributeType);
        } else {
            node = new ExtensibleNode(attribute);
        }
        if (attribute != null) {
            if (Strings.areEquals(filter, pos.start, "dn") >= 0) {
                node.setDnAttributes(true);
                pos.start += 2;
            } else {
                --pos.start;
            }
            if (Strings.byteAt(filter, pos.start) != 58) throw new ParseException(I18n.err(I18n.ERR_04147, new Object[0]), pos.start);
            ++pos.start;
            int start = pos.start;
            if (Strings.byteAt(filter, pos.start) == 61) {
                ++pos.start;
                node.setValue(FilterParser.parseAssertionValue(filter, pos));
                return node;
            }
            String matchingRuleId = AttributeUtils.parseAttribute(filter, pos, false);
            node.setMatchingRuleId(matchingRuleId);
            if (Strings.areEquals(filter, pos.start, ":=") < 0) throw new ParseException(I18n.err(I18n.ERR_04146, new Object[0]), pos.start);
            pos.start += 2;
            node.setValue(FilterParser.parseAssertionValue(filter, pos));
            return node;
        }
        boolean oidRequested = false;
        if (Strings.areEquals(filter, pos.start, ":dn") >= 0) {
            node.setDnAttributes(true);
            pos.start += 3;
        } else {
            oidRequested = true;
        }
        if (Strings.byteAt(filter, pos.start) != 58) throw new ParseException(I18n.err(I18n.ERR_04147, new Object[0]), pos.start);
        ++pos.start;
        int start = pos.start;
        if (Strings.byteAt(filter, pos.start) == 61) {
            if (oidRequested) {
                throw new ParseException(I18n.err(I18n.ERR_04148, new Object[0]), pos.start);
            }
            ++pos.start;
            node.setValue(FilterParser.parseAssertionValue(filter, pos));
            return node;
        }
        String matchingRuleId = AttributeUtils.parseAttribute(filter, pos, false);
        node.setMatchingRuleId(matchingRuleId);
        if (Strings.areEquals(filter, pos.start, ":=") < 0) throw new ParseException(I18n.err(I18n.ERR_04146, new Object[0]), pos.start);
        pos.start += 2;
        node.setValue(FilterParser.parseAssertionValue(filter, pos));
        return node;
    }

    private static Value<?> parseAssertionValue(byte[] filter, Position pos) throws ParseException {
        byte b = Strings.byteAt(filter, pos.start);
        byte[] value = new byte[filter.length - pos.start];
        int current = 0;
        do {
            if (Unicode.isUnicodeSubset(b)) {
                value[current++] = b;
                ++pos.start;
                continue;
            }
            if (!Strings.isCharASCII(filter, pos.start, '\\')) break;
            ++pos.start;
            if (Chars.isHex(filter, pos.start)) {
                ++pos.start;
            } else {
                throw new ParseException(I18n.err(I18n.ERR_04149, new Object[0]), pos.start);
            }
            if (Chars.isHex(filter, pos.start)) {
                value[current++] = Hex.getHexValue(filter[pos.start - 1], filter[pos.start]);
                ++pos.start;
                continue;
            }
            throw new ParseException(I18n.err(I18n.ERR_04149, new Object[0]), pos.start);
        } while ((b = Strings.byteAt(filter, pos.start)) != 0);
        if (current != 0) {
            byte[] result = new byte[current];
            System.arraycopy(value, 0, result, 0, current);
            return new BinaryValue(result);
        }
        return new BinaryValue((byte[])null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ExprNode parseSubstring(SchemaManager schemaManager, String attribute, Value<?> initial, byte[] filter, Position pos) throws ParseException, LdapException {
        if (!Strings.isCharASCII(filter, pos.start, '*')) throw new ParseException(I18n.err(I18n.ERR_04150, new Object[0]), pos.start);
        SubstringNode node = null;
        if (schemaManager != null) {
            AttributeType attributeType = schemaManager.lookupAttributeTypeRegistry(attribute);
            if (attributeType == null) return null;
            node = new SubstringNode(schemaManager.lookupAttributeTypeRegistry(attribute));
        } else {
            node = new SubstringNode(attribute);
        }
        if (initial != null && !initial.isNull()) {
            String initialStr = initial.getString();
            node.setInitial(initialStr);
        }
        ++pos.start;
        while (true) {
            Value<?> assertionValue = FilterParser.parseAssertionValue(filter, pos);
            if (Strings.isCharASCII(filter, pos.start, ')')) {
                if (assertionValue.isNull()) return node;
                String finalStr = assertionValue.getString();
                node.setFinal(finalStr);
                return node;
            }
            if (!Strings.isCharASCII(filter, pos.start, '*')) throw new ParseException(I18n.err(I18n.ERR_04150, new Object[0]), pos.start);
            if (!assertionValue.isNull()) {
                String anyStr = assertionValue.getString();
                node.addAny(anyStr);
            }
            ++pos.start;
        }
    }

    private static ExprNode parsePresenceEqOrSubstring(SchemaManager schemaManager, String attribute, byte[] filter, Position pos) throws ParseException, LdapException {
        if (Strings.isCharASCII(filter, pos.start, '*')) {
            ++pos.start;
            if (Strings.isCharASCII(filter, pos.start, ')')) {
                if (schemaManager != null) {
                    AttributeType attributeType = schemaManager.getAttributeType(attribute);
                    if (attributeType != null) {
                        return new PresenceNode(attributeType);
                    }
                    return null;
                }
                return new PresenceNode(attribute);
            }
            --pos.start;
            return FilterParser.parseSubstring(schemaManager, attribute, null, filter, pos);
        }
        if (Strings.isCharASCII(filter, pos.start, ')')) {
            if (schemaManager != null) {
                AttributeType attributeType = schemaManager.getAttributeType(attribute);
                if (attributeType != null) {
                    return new EqualityNode<byte[]>(attributeType, new BinaryValue((byte[])null));
                }
                return null;
            }
            return new EqualityNode<byte[]>(attribute, new BinaryValue((byte[])null));
        }
        Value<?> value = FilterParser.parseAssertionValue(filter, pos);
        if (Strings.isCharASCII(filter, pos.start, ')')) {
            if (schemaManager != null) {
                AttributeType attributeType = schemaManager.getAttributeType(attribute);
                if (attributeType != null) {
                    return new EqualityNode(attributeType, value);
                }
                return null;
            }
            return new EqualityNode(attribute, value);
        }
        return FilterParser.parseSubstring(schemaManager, attribute, value, filter, pos);
    }

    private static ExprNode parseItem(SchemaManager schemaManager, byte[] filter, Position pos, byte b) throws ParseException, LdapException {
        String attribute = null;
        if (b == 0) {
            throw new ParseException(I18n.err(I18n.ERR_04151, new Object[0]), pos.start);
        }
        if (b == 58) {
            return FilterParser.parseExtensible(schemaManager, null, filter, pos);
        }
        attribute = AttributeUtils.parseAttribute(filter, pos, true);
        b = Strings.byteAt(filter, pos.start);
        switch (b) {
            case 61: {
                ++pos.start;
                return FilterParser.parsePresenceEqOrSubstring(schemaManager, attribute, filter, pos);
            }
            case 126: {
                ++pos.start;
                if (!Strings.isCharASCII(filter, pos.start, '=')) {
                    throw new ParseException(I18n.err(I18n.ERR_04152, new Object[0]), pos.start);
                }
                ++pos.start;
                if (schemaManager == null) {
                    return new ApproximateNode(attribute, FilterParser.parseAssertionValue(filter, pos));
                }
                AttributeType attributeType = schemaManager.getAttributeType(attribute);
                if (attributeType != null) {
                    return new ApproximateNode(attributeType, FilterParser.parseAssertionValue(filter, pos));
                }
                return UndefinedNode.UNDEFINED_NODE;
            }
            case 62: {
                ++pos.start;
                if (!Strings.isCharASCII(filter, pos.start, '=')) {
                    throw new ParseException(I18n.err(I18n.ERR_04152, new Object[0]), pos.start);
                }
                ++pos.start;
                if (schemaManager == null) {
                    return new GreaterEqNode(attribute, FilterParser.parseAssertionValue(filter, pos));
                }
                AttributeType attributeType = schemaManager.getAttributeType(attribute);
                if (attributeType != null) {
                    return new GreaterEqNode(attributeType, FilterParser.parseAssertionValue(filter, pos));
                }
                return UndefinedNode.UNDEFINED_NODE;
            }
            case 60: {
                ++pos.start;
                if (!Strings.isCharASCII(filter, pos.start, '=')) {
                    throw new ParseException(I18n.err(I18n.ERR_04152, new Object[0]), pos.start);
                }
                ++pos.start;
                if (schemaManager == null) {
                    return new LessEqNode(attribute, FilterParser.parseAssertionValue(filter, pos));
                }
                AttributeType attributeType = schemaManager.getAttributeType(attribute);
                if (attributeType != null) {
                    return new LessEqNode(attributeType, FilterParser.parseAssertionValue(filter, pos));
                }
                return UndefinedNode.UNDEFINED_NODE;
            }
            case 58: {
                ++pos.start;
                return FilterParser.parseExtensible(schemaManager, attribute, filter, pos);
            }
        }
        throw new ParseException(I18n.err(I18n.ERR_04153, new Object[0]), pos.start);
    }

    private static ExprNode parseBranchNode(SchemaManager schemaManager, ExprNode node, byte[] filter, Position pos) throws ParseException, LdapException {
        BranchNode branchNode = (BranchNode)node;
        int nbChildren = 0;
        ExprNode child = FilterParser.parseFilterInternal(schemaManager, filter, pos);
        if (child != UndefinedNode.UNDEFINED_NODE) {
            branchNode.addNode(child);
            if (branchNode instanceof NotNode) {
                return node;
            }
            ++nbChildren;
        } else if (node instanceof AndNode) {
            return UndefinedNode.UNDEFINED_NODE;
        }
        while ((child = FilterParser.parseFilterInternal(schemaManager, filter, pos)) != UndefinedNode.UNDEFINED_NODE) {
            if (child != null) {
                branchNode.addNode(child);
                ++nbChildren;
                continue;
            }
            if (!(node instanceof AndNode)) continue;
            return UndefinedNode.UNDEFINED_NODE;
        }
        if (nbChildren > 0) {
            return node;
        }
        return UndefinedNode.UNDEFINED_NODE;
    }

    private static ExprNode parseFilterComp(SchemaManager schemaManager, byte[] filter, Position pos) throws ParseException, LdapException {
        ExprNode node = null;
        if (pos.start == pos.length) {
            throw new ParseException(I18n.err(I18n.ERR_04154, new Object[0]), pos.start);
        }
        byte c = Strings.byteAt(filter, pos.start);
        switch (c) {
            case 38: {
                ++pos.start;
                node = new AndNode();
                node = FilterParser.parseBranchNode(schemaManager, node, filter, pos);
                break;
            }
            case 124: {
                ++pos.start;
                node = new OrNode();
                node = FilterParser.parseBranchNode(schemaManager, node, filter, pos);
                break;
            }
            case 33: {
                ++pos.start;
                node = new NotNode();
                node = FilterParser.parseBranchNode(schemaManager, node, filter, pos);
                break;
            }
            default: {
                node = FilterParser.parseItem(schemaManager, filter, pos, c);
            }
        }
        return node;
    }

    private static ExprNode parseFilterInternal(SchemaManager schemaManager, byte[] filter, Position pos) throws ParseException, LdapException {
        if (!Strings.isCharASCII(filter, pos.start, '(')) {
            if (pos.start == 0 && pos.length != 0) {
                throw new ParseException(I18n.err(I18n.ERR_04155, new Object[0]), 0);
            }
            return UndefinedNode.UNDEFINED_NODE;
        }
        ++pos.start;
        ExprNode node = FilterParser.parseFilterComp(schemaManager, filter, pos);
        if (node == UndefinedNode.UNDEFINED_NODE) {
            return UndefinedNode.UNDEFINED_NODE;
        }
        if (!Strings.isCharASCII(filter, pos.start, ')')) {
            throw new ParseException(I18n.err(I18n.ERR_04157, new Object[0]), pos.start);
        }
        ++pos.start;
        return node;
    }

    public static ExprNode parse(String filter) throws ParseException {
        return FilterParser.parse(null, Strings.getBytesUtf8(filter));
    }

    public static ExprNode parse(byte[] filter) throws ParseException {
        return FilterParser.parse(null, filter);
    }

    public static ExprNode parse(SchemaManager schemaManager, String filter) throws ParseException {
        return FilterParser.parse(schemaManager, Strings.getBytesUtf8(filter));
    }

    public static ExprNode parse(SchemaManager schemaManager, byte[] filter) throws ParseException {
        if (Strings.isEmpty(filter)) {
            throw new ParseException(I18n.err(I18n.ERR_04158, new Object[0]), 0);
        }
        Position pos = new Position();
        pos.start = 0;
        pos.end = 0;
        pos.length = filter.length;
        try {
            return FilterParser.parseFilterInternal(schemaManager, filter, pos);
        }
        catch (LdapException le) {
            throw new ParseException(le.getMessage(), pos.start);
        }
    }

    public static ExprNode parse(SchemaManager schemaManager, String filter, Position pos) throws ParseException {
        if (Strings.isEmpty(filter)) {
            throw new ParseException(I18n.err(I18n.ERR_04158, new Object[0]), 0);
        }
        pos.start = 0;
        pos.end = 0;
        pos.length = filter.length();
        try {
            return FilterParser.parseFilterInternal(schemaManager, Strings.getBytesUtf8(filter), pos);
        }
        catch (LdapException le) {
            throw new ParseException(le.getMessage(), pos.start);
        }
    }
}

