/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.log.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.log.InvalidLogException;
import org.apache.directory.server.log.LogAnchor;
import org.apache.directory.server.log.UserLogRecord;
import org.apache.directory.server.log.impl.LogFileManager;
import org.apache.directory.server.log.impl.LogFileRecords;
import org.apache.directory.server.log.impl.LogManager;

class LogFlushManager {
    private long logLSN = -9223372036854775807L;
    private final int logBufferSize;
    private final Lock appendLock = new ReentrantLock();
    private final Lock flushLock = new ReentrantLock();
    private final Condition flushCondition = this.flushLock.newCondition();
    private LogBuffer logBuffer;
    private FlushStatus flushStatus = new FlushStatus();
    private LogFileManager.LogFileWriter currentLogFile;
    LogManager logManager;
    long appendedSize;
    long targetLogFileSize;

    public LogFlushManager(LogManager logManager, int logMemoryBufferSize, long logFileSize) {
        if (logMemoryBufferSize < 0 || logFileSize < 0L) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_748, logMemoryBufferSize, logFileSize));
        }
        this.logBufferSize = logMemoryBufferSize;
        this.targetLogFileSize = logFileSize;
        this.logManager = logManager;
        this.logBuffer = new LogBuffer(this.logBufferSize, this.currentLogFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(UserLogRecord userRecord, boolean sync) throws IOException, InvalidLogException {
        long lsn;
        boolean appendedRecord = false;
        byte[] userBuffer = userRecord.getDataBuffer();
        int length = userRecord.getDataLength();
        LogAnchor userLogAnchor = userRecord.getLogAnchor();
        int recordSize = 32 + length;
        this.appendLock.lock();
        try {
            lsn = this.logLSN++;
            if (this.currentLogFile == null) {
                this.currentLogFile = this.logManager.switchToNextLogFile(null);
                this.appendedSize = this.currentLogFile.getLength();
            }
            if (this.appendedSize > this.targetLogFileSize) {
                this.flush(lsn, null, 0, 0, true);
                this.currentLogFile = this.logManager.switchToNextLogFile(this.currentLogFile);
                this.appendedSize = this.currentLogFile.getLength();
            }
            if (recordSize <= this.logBufferSize) {
                ByteBuffer writeHead = this.logBuffer.writeHead;
                while (!appendedRecord) {
                    int readHeadRewindCount = this.logBuffer.readHeadRewindCount.get();
                    int readHeadPosition = this.logBuffer.readHeadPosition;
                    if (this.logBuffer.writeHeadRewindCount == readHeadRewindCount || this.logBuffer.writeHeadRewindCount == readHeadRewindCount + 1 && readHeadPosition < writeHead.position()) {
                        if (writeHead.remaining() >= recordSize) {
                            this.writeHeader(writeHead, length, lsn);
                            writeHead.put(userBuffer, 0, length);
                            this.writeFooter(writeHead, 0);
                            appendedRecord = true;
                            continue;
                        }
                        if (writeHead.remaining() >= 24) {
                            this.writeHeader(writeHead, -1, -1L);
                        }
                        writeHead.rewind();
                        ++this.logBuffer.writeHeadRewindCount;
                        continue;
                    }
                    assert (this.logBuffer.writeHeadRewindCount == readHeadRewindCount + 1) : "Unexpected sequence number for read/write heads:" + this.logBuffer.writeHeadRewindCount + " " + readHeadRewindCount;
                    if (readHeadPosition - writeHead.position() > recordSize) {
                        this.writeHeader(writeHead, length, lsn);
                        writeHead.put(userBuffer, 0, length);
                        this.writeFooter(writeHead, 0);
                        appendedRecord = true;
                        continue;
                    }
                    this.flush(lsn, null, 0, 0, true);
                }
            } else {
                this.flush(lsn, userBuffer, 0, length, true);
            }
            userLogAnchor.resetLogAnchor(this.currentLogFile.logFileNumber(), this.appendedSize, lsn);
            this.appendedSize += (long)recordSize;
        }
        finally {
            this.appendLock.unlock();
        }
        if (sync) {
            this.flush(lsn, null, 0, 0, false);
        }
    }

    private void flush(long flushLSN, byte[] userBuffer, int offset, int length, boolean appendLockHeld) throws IOException {
        long uptoLSN = flushLSN;
        if (appendLockHeld) {
            --uptoLSN;
        }
        this.flushLock.lock();
        if (uptoLSN > this.flushStatus.uptoLSN) {
            this.flushStatus.uptoLSN = uptoLSN;
        }
        while (true) {
            if (this.flushStatus.flushedLSN >= uptoLSN && !appendLockHeld) {
                this.flushLock.unlock();
                return;
            }
            if (!this.flushStatus.flushInProgress) break;
            ++this.flushStatus.numWaiters;
            this.flushCondition.awaitUninterruptibly();
            --this.flushStatus.numWaiters;
        }
        this.flushStatus.flushInProgress = true;
        uptoLSN = !appendLockHeld ? this.flushStatus.uptoLSN : flushLSN;
        this.flushLock.unlock();
        long flushedLSN = this.doFlush(uptoLSN, appendLockHeld);
        if (userBuffer != null) {
            ByteBuffer headerFooterHead = this.logBuffer.headerFooterHead;
            headerFooterHead.rewind();
            this.writeHeader(headerFooterHead, length, flushLSN);
            this.currentLogFile.append(this.logBuffer.headerFooterBuffer, 0, 0x10F010F);
            this.currentLogFile.append(userBuffer, offset, length);
            headerFooterHead.rewind();
            this.writeFooter(headerFooterHead, 0);
            this.currentLogFile.append(this.logBuffer.headerFooterBuffer, 0, 8);
            flushedLSN = flushLSN;
        }
        this.currentLogFile.sync();
        this.flushLock.lock();
        if (flushedLSN != Long.MIN_VALUE) {
            this.flushStatus.flushedLSN = flushedLSN;
            if (this.flushStatus.flushedLSN > this.flushStatus.uptoLSN) {
                assert (appendLockHeld) : "FlushedLSN went ahead of uptoLSN while appendlock is not held: " + this.flushStatus.flushedLSN + "  " + this.flushStatus.uptoLSN;
                this.flushStatus.uptoLSN = this.flushStatus.flushedLSN;
            }
        }
        this.flushStatus.flushInProgress = false;
        if (this.flushStatus.numWaiters != 0) {
            this.flushCondition.signalAll();
        }
        this.flushLock.unlock();
    }

    private long doFlush(long uptoLSN, boolean appendLockHeld) throws IOException {
        ByteBuffer readHead = this.logBuffer.readHead;
        ByteBuffer writeHead = this.logBuffer.writeHead;
        boolean done = false;
        long lsn = Long.MIN_VALUE;
        while (!done) {
            int totalLength;
            block6: {
                totalLength = 0;
                do {
                    if (appendLockHeld && writeHead.position() == readHead.position() && this.logBuffer.writeHeadRewindCount == this.logBuffer.readHeadRewindCount.get()) {
                        done = true;
                        break block6;
                    }
                    if (readHead.remaining() < 24) break block6;
                    int magicNumber = readHead.getInt();
                    assert (magicNumber == 0x10F010F) : " Record header magic number does not match " + magicNumber + " expected " + 0x10F010F;
                    int length = readHead.getInt();
                    if (length == -1) break block6;
                    assert (length > 0x10101010) : "Record length doesnt make sense:" + length + " expected:" + 0x10101010;
                    totalLength += length;
                    lsn = readHead.getLong();
                    readHead.position(readHead.position() + length - 16);
                } while (lsn < uptoLSN);
                done = true;
            }
            if (totalLength > 0) {
                int offset = this.logBuffer.readHeadPosition;
                this.currentLogFile.append(this.logBuffer.buffer, offset, totalLength);
                this.logBuffer.readHeadPosition = readHead.position();
            }
            if (done) continue;
            this.logBuffer.readHeadPosition = 0;
            readHead.rewind();
            this.logBuffer.readHeadRewindCount.incrementAndGet();
        }
        return lsn;
    }

    private void writeHeader(ByteBuffer buffer, int length, long lsn) {
        buffer.putInt(0x10F010F);
        buffer.putInt(length);
        buffer.putLong(lsn);
        buffer.putLong((long)length ^ lsn);
    }

    private void writeFooter(ByteBuffer buffer, int checksum) {
        buffer.putInt(checksum);
        buffer.putInt(0xF010F01);
    }

    private static class FlushStatus {
        boolean flushInProgress;
        long uptoLSN;
        long flushedLSN;
        int numWaiters;

        private FlushStatus() {
        }
    }

    private static class LogBuffer {
        byte[] buffer;
        ByteBuffer readHead;
        int readHeadPosition;
        AtomicInteger readHeadRewindCount;
        ByteBuffer writeHead;
        int writeHeadRewindCount;
        static final int SKIP_RECORD_LENGTH = -1;
        byte[] headerFooterBuffer;
        ByteBuffer headerFooterHead;

        public LogBuffer(int bufferSize, LogFileManager.LogFileWriter currentLogFile) {
            this.buffer = new byte[bufferSize];
            this.readHead = ByteBuffer.wrap(this.buffer);
            this.readHeadRewindCount = new AtomicInteger(0);
            this.writeHead = ByteBuffer.wrap(this.buffer);
            this.headerFooterBuffer = new byte[LogFileRecords.MAX_MARKER_SIZE];
            this.headerFooterHead = ByteBuffer.wrap(this.headerFooterBuffer);
        }
    }
}

