/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.kerberos;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.crypto.encryption.RandomKeyFactory;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDerivationInterceptor
extends BaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(KeyDerivationInterceptor.class);
    private static final String NAME = "keyDerivationService";

    public KeyDerivationInterceptor() {
        super(NAME);
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        Dn normName = addContext.getDn();
        Entry entry = addContext.getEntry();
        if (entry.get("userPassword") != null && entry.get("krb5PrincipalName") != null) {
            log.debug("Adding the entry '{}' for Dn '{}'.", entry, (Object)normName.getName());
            BinaryValue userPassword = (BinaryValue)entry.get("userPassword").get();
            String strUserPassword = userPassword.getString();
            if (log.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("'" + strUserPassword + "' ( ");
                sb.append(userPassword);
                sb.append(" )");
                log.debug("Adding Attribute id : 'userPassword',  Values : [ {} ]", (Object)sb.toString());
            }
            Value<?> principalNameValue = entry.get("krb5PrincipalName").get();
            String principalName = principalNameValue.getString();
            log.debug("Got principal '{}' with userPassword '{}'.", (Object)principalName, (Object)strUserPassword);
            Map<EncryptionType, EncryptionKey> keys = this.generateKeys(principalName, strUserPassword);
            entry.put("krb5PrincipalName", principalName);
            entry.put("krb5KeyVersionNumber", "0");
            entry.put(this.getKeyAttribute(addContext.getSession().getDirectoryService().getSchemaManager(), keys));
            log.debug("Adding modified entry '{}' for Dn '{}'.", entry, (Object)normName.getName());
        }
        this.next(addContext);
    }

    @Override
    public void modify(ModifyOperationContext modContext) throws LdapException {
        ModifySubContext subContext = new ModifySubContext();
        this.detectPasswordModification(modContext, subContext);
        if (subContext.getUserPassword() != null) {
            this.lookupPrincipalAttributes(modContext, subContext);
        }
        if (subContext.isPrincipal() && subContext.hasValues()) {
            this.deriveKeys(modContext, subContext);
        }
        this.next(modContext);
    }

    void detectPasswordModification(ModifyOperationContext modContext, ModifySubContext subContext) throws LdapException {
        List<Modification> mods = modContext.getModItems();
        String operation = null;
        for (Modification mod : mods) {
            Attribute attr;
            if (log.isDebugEnabled()) {
                switch (mod.getOperation()) {
                    case ADD_ATTRIBUTE: {
                        operation = "Adding";
                        break;
                    }
                    case REMOVE_ATTRIBUTE: {
                        operation = "Removing";
                        break;
                    }
                    case REPLACE_ATTRIBUTE: {
                        operation = "Replacing";
                    }
                }
            }
            if ("2.5.4.35".equals((attr = mod.getAttribute()).getAttributeType().getOid())) {
                Value<?> firstValue = attr.get();
                String password = null;
                if (firstValue instanceof StringValue) {
                    password = ((StringValue)firstValue).getString();
                    log.debug("{} Attribute id : 'userPassword',  Values : [ '{}' ]", (Object)operation, (Object)password);
                } else if (firstValue instanceof BinaryValue) {
                    password = ((BinaryValue)firstValue).getString();
                    if (log.isDebugEnabled()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("'" + password + "' ( ");
                        sb.append(Strings.dumpBytes(((BinaryValue)firstValue).getBytes()).trim());
                        sb.append(" )");
                        log.debug("{} Attribute id : 'userPassword',  Values : [ {} ]", (Object)operation, (Object)sb.toString());
                    }
                }
                subContext.setUserPassword(password);
                log.debug("Got userPassword '{}'.", (Object)subContext.getUserPassword());
            }
            if (!"1.3.6.1.4.1.5322.10.1.1".equals(attr.getAttributeType().getOid())) continue;
            subContext.setPrincipalName(attr.getString());
            log.debug("Got principal '{}'.", (Object)subContext.getPrincipalName());
        }
    }

    void lookupPrincipalAttributes(ModifyOperationContext modContext, ModifySubContext subContext) throws LdapException {
        Attribute keyVersionNumberAttr;
        Dn principalDn = modContext.getDn();
        LookupOperationContext lookupContext = modContext.newLookupContext(principalDn);
        lookupContext.setAttrsId(new String[]{"objectClass", "krb5PrincipalName", "krb5KeyVersionNumber"});
        Entry userEntry = this.directoryService.getPartitionNexus().lookup(lookupContext);
        if (userEntry == null) {
            throw new LdapAuthenticationException(I18n.err(I18n.ERR_512, principalDn));
        }
        Attribute objectClass = ((ClonedServerEntry)userEntry).getOriginalEntry().get("objectClass");
        if (!objectClass.contains("krb5Principal")) {
            return;
        }
        subContext.isPrincipal(true);
        log.debug("Dn {} is a Kerberos principal.  Will attempt key derivation.", (Object)principalDn.getName());
        if (subContext.getPrincipalName() == null) {
            Attribute principalAttribute = ((ClonedServerEntry)userEntry).getOriginalEntry().get("krb5PrincipalName");
            String principalName = principalAttribute.getString();
            subContext.setPrincipalName(principalName);
            log.debug("Found principal '{}' from lookup.", (Object)principalName);
        }
        if ((keyVersionNumberAttr = ((ClonedServerEntry)userEntry).getOriginalEntry().get("krb5KeyVersionNumber")) == null) {
            subContext.setNewKeyVersionNumber(0);
            log.debug("Key version number was null, setting to 0.");
        } else {
            int oldKeyVersionNumber = Integer.valueOf(keyVersionNumberAttr.getString());
            int newKeyVersionNumber = oldKeyVersionNumber + 1;
            subContext.setNewKeyVersionNumber(newKeyVersionNumber);
            log.debug("Found key version number '{}', setting to '{}'.", oldKeyVersionNumber, (Object)newKeyVersionNumber);
        }
    }

    void deriveKeys(ModifyOperationContext modContext, ModifySubContext subContext) throws LdapException {
        List<Modification> mods = modContext.getModItems();
        String principalName = subContext.getPrincipalName();
        String userPassword = subContext.getUserPassword();
        int kvno = subContext.getNewKeyVersionNumber();
        log.debug("Got principal '{}' with userPassword '{}'.", (Object)principalName, (Object)userPassword);
        Map<EncryptionType, EncryptionKey> keys = this.generateKeys(principalName, userPassword);
        ArrayList<Modification> newModsList = new ArrayList<Modification>();
        for (Modification mod : mods) {
            newModsList.add(mod);
        }
        SchemaManager schemaManager = modContext.getSession().getDirectoryService().getSchemaManager();
        newModsList.add(new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, new DefaultAttribute("krb5PrincipalName", schemaManager.lookupAttributeTypeRegistry("krb5PrincipalName"), principalName)));
        newModsList.add(new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, new DefaultAttribute("krb5KeyVersionNumber", schemaManager.lookupAttributeTypeRegistry("krb5KeyVersionNumber"), Integer.toString(kvno))));
        Attribute attribute = this.getKeyAttribute(modContext.getSession().getDirectoryService().getSchemaManager(), keys);
        newModsList.add(new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute));
        modContext.setModItems(newModsList);
    }

    private Attribute getKeyAttribute(SchemaManager schemaManager, Map<EncryptionType, EncryptionKey> keys) throws LdapException {
        DefaultAttribute keyAttribute = new DefaultAttribute("krb5Key", schemaManager.lookupAttributeTypeRegistry("krb5Key"));
        for (EncryptionKey encryptionKey : keys.values()) {
            try {
                ByteBuffer buffer = ByteBuffer.allocate(encryptionKey.computeLength());
                encryptionKey.encode(buffer);
                keyAttribute.add(new byte[][]{buffer.array()});
            }
            catch (EncoderException ioe) {
                log.error(I18n.err(I18n.ERR_122, new Object[0]), ioe);
            }
        }
        return keyAttribute;
    }

    private Map<EncryptionType, EncryptionKey> generateKeys(String principalName, String userPassword) {
        if (userPassword.equalsIgnoreCase("randomKey")) {
            try {
                return RandomKeyFactory.getRandomKeys();
            }
            catch (KerberosException ke) {
                log.debug(ke.getLocalizedMessage(), ke);
                return null;
            }
        }
        return KerberosKeyFactory.getKerberosKeys(principalName, userPassword);
    }

    static class ModifySubContext {
        private boolean isPrincipal = false;
        private String principalName;
        private String userPassword;
        private int newKeyVersionNumber = -1;

        ModifySubContext() {
        }

        boolean isPrincipal() {
            return this.isPrincipal;
        }

        void isPrincipal(boolean isPrincipal) {
            this.isPrincipal = isPrincipal;
        }

        String getPrincipalName() {
            return this.principalName;
        }

        void setPrincipalName(String principalName) {
            this.principalName = principalName;
        }

        String getUserPassword() {
            return this.userPassword;
        }

        void setUserPassword(String userPassword) {
            this.userPassword = userPassword;
        }

        int getNewKeyVersionNumber() {
            return this.newKeyVersionNumber;
        }

        void setNewKeyVersionNumber(int newKeyVersionNumber) {
            this.newKeyVersionNumber = newKeyVersionNumber;
        }

        boolean hasValues() {
            return this.userPassword != null && this.principalName != null && this.newKeyVersionNumber > -1;
        }
    }
}

