/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.log.impl;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.log.InvalidLogException;
import org.apache.directory.server.log.LogAnchor;
import org.apache.directory.server.log.LogAnchorComparator;
import org.apache.directory.server.log.UserLogRecord;
import org.apache.directory.server.log.impl.DefaultLogScanner;
import org.apache.directory.server.log.impl.LogFileManager;

class LogManager {
    private static final int CONTROLFILE_RECORD_SIZE = 36;
    private static final int CONTROLFILE_MAGIC_NUMBER = -15597807;
    private static final long CONTROLFILE_LOG_FILE_NUMBER = -1L;
    private static final long CONTROLFILE_SHADOW_LOG_FILE_NUMBER = -2L;
    byte[] controlFileBuffer = new byte[36];
    ByteBuffer controlFileMarker = ByteBuffer.wrap(this.controlFileBuffer);
    ControlFileRecord controlFileRecord = new ControlFileRecord();
    LogAnchor minLogAnchor = new LogAnchor();
    Lock minLogAnchorLock = new ReentrantLock();
    LogFileManager logFileManager;
    LogAnchorComparator anchorComparator = new LogAnchorComparator();
    private long currentLogFileNumber;
    byte[] markerBuffer = new byte[12];
    ByteBuffer markerHead = ByteBuffer.wrap(this.markerBuffer);

    public LogManager(LogFileManager logFileManager) {
        this.logFileManager = logFileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initLogManager() throws IOException, InvalidLogException {
        LogFileManager.LogFileReader reader;
        LogAnchor scanPoint = new LogAnchor();
        boolean controlFileExists = true;
        try {
            this.readControlFile();
        }
        catch (FileNotFoundException e) {
            controlFileExists = false;
        }
        if (controlFileExists) {
            boolean invalidLog = false;
            this.minLogAnchor.resetLogAnchor(this.controlFileRecord.minNeededLogFile, this.controlFileRecord.minNeededLogFileOffset, this.controlFileRecord.minNeededLSN);
            scanPoint.resetLogAnchor(this.minLogAnchor);
            UserLogRecord logRecord = new UserLogRecord();
            DefaultLogScanner scanner = new DefaultLogScanner(scanPoint, this.logFileManager);
            try {
                while (scanner.getNextRecord(logRecord)) {
                }
            }
            catch (InvalidLogException e) {
                invalidLog = true;
            }
            finally {
                scanner.close();
            }
            long lastGoodLogFileNumber = scanner.getLastGoodFileNumber();
            long lastGoodLogFileOffset = scanner.getLastGoodOffset();
            this.currentLogFileNumber = lastGoodLogFileNumber;
            if (lastGoodLogFileNumber < 0L || lastGoodLogFileOffset < 0L) {
                throw new InvalidLogException(I18n.err(I18n.ERR_750, new Object[0]));
            }
            scanPoint.resetLogAnchor(lastGoodLogFileNumber, lastGoodLogFileOffset, Long.MIN_VALUE);
            if (this.anchorComparator.compare(scanPoint, this.minLogAnchor) < 0) {
                throw new InvalidLogException(I18n.err(I18n.ERR_750, new Object[0]));
            }
            if (invalidLog) {
                reader = null;
                try {
                    reader = this.logFileManager.getReaderForLogFile(lastGoodLogFileNumber + 1L);
                }
                catch (FileNotFoundException e) {
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                if (reader != null) {
                    throw new InvalidLogException(I18n.err(I18n.ERR_750, new Object[0]));
                }
                if (lastGoodLogFileOffset >= 12L) {
                    this.logFileManager.truncateLogFile(lastGoodLogFileNumber, lastGoodLogFileOffset);
                } else {
                    this.createNextLogFile(true);
                }
            }
        }
        reader = null;
        boolean fileExists = false;
        this.currentLogFileNumber = 0L;
        try {
            reader = this.logFileManager.getReaderForLogFile(0L);
            if (reader.getLength() > 12L) {
                throw new InvalidLogException(I18n.err(I18n.ERR_750, new Object[0]));
            }
            fileExists = true;
        }
        catch (FileNotFoundException e) {
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        this.createNextLogFile(fileExists);
        this.minLogAnchor.resetLogAnchor(0L, 12L, Long.MIN_VALUE);
        this.writeControlFile();
    }

    public LogFileManager.LogFileWriter switchToNextLogFile(LogFileManager.LogFileWriter currentWriter) throws IOException, InvalidLogException {
        if (currentWriter != null) {
            currentWriter.close();
            this.writeControlFile();
            this.createNextLogFile(false);
        }
        return this.logFileManager.getWriterForLogFile(this.currentLogFileNumber);
    }

    public void advanceMinLogAnchor(LogAnchor newLogAnchor) {
        if (newLogAnchor == null) {
            return;
        }
        this.minLogAnchorLock.lock();
        if (this.anchorComparator.compare(this.minLogAnchor, newLogAnchor) < 0) {
            this.minLogAnchor.resetLogAnchor(newLogAnchor);
        }
        this.minLogAnchorLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeControlFile() throws IOException {
        this.minLogAnchorLock.lock();
        this.controlFileRecord.minNeededLogFile = this.minLogAnchor.getLogFileNumber();
        this.controlFileRecord.minNeededLogFileOffset = this.minLogAnchor.getLogFileOffset();
        this.controlFileRecord.minNeededLSN = this.minLogAnchor.getLogLSN();
        this.minLogAnchorLock.unlock();
        if (this.controlFileRecord.minNeededLogFile > this.controlFileRecord.minExistingLogFile) {
            this.deleteUnnecessaryLogFiles(this.controlFileRecord.minExistingLogFile, this.controlFileRecord.minNeededLogFile);
            this.controlFileRecord.minExistingLogFile = this.controlFileRecord.minNeededLogFile;
        }
        this.controlFileMarker.rewind();
        this.controlFileMarker.putLong(this.controlFileRecord.minExistingLogFile);
        this.controlFileMarker.putLong(this.controlFileRecord.minNeededLogFile);
        this.controlFileMarker.putLong(this.controlFileRecord.minNeededLogFileOffset);
        this.controlFileMarker.putLong(this.controlFileRecord.minNeededLSN);
        this.controlFileMarker.putLong(this.controlFileRecord.checksum);
        this.controlFileMarker.putInt(-15597807);
        boolean shadowFileExists = this.logFileManager.createLogFile(-2L);
        if (shadowFileExists) {
            this.logFileManager.truncateLogFile(-2L, 0L);
        }
        LogFileManager.LogFileWriter controlFileWriter = this.logFileManager.getWriterForLogFile(-2L);
        try {
            controlFileWriter.append(this.controlFileBuffer, 0, 36);
            controlFileWriter.sync();
        }
        finally {
            controlFileWriter.close();
        }
        this.logFileManager.rename(-2L, -1L);
    }

    private void readControlFile() throws IOException, InvalidLogException, FileNotFoundException {
        boolean invalidControlFile = false;
        LogFileManager.LogFileReader controlFileReader = this.logFileManager.getReaderForLogFile(-1L);
        try {
            controlFileReader.read(this.controlFileBuffer, 0, 36);
        }
        catch (EOFException e) {
            throw new InvalidLogException(I18n.err(I18n.ERR_750, new Object[0]), e);
        }
        finally {
            controlFileReader.close();
        }
        this.controlFileMarker.rewind();
        this.controlFileRecord.minExistingLogFile = this.controlFileMarker.getLong();
        this.controlFileRecord.minNeededLogFile = this.controlFileMarker.getLong();
        this.controlFileRecord.minNeededLogFileOffset = this.controlFileMarker.getLong();
        this.controlFileRecord.minNeededLSN = this.controlFileMarker.getLong();
        this.controlFileRecord.checksum = this.controlFileMarker.getLong();
        int magicNumber = this.controlFileMarker.getInt();
        if (this.controlFileRecord.minExistingLogFile < 0L) {
            invalidControlFile = true;
        }
        if (this.controlFileRecord.minNeededLogFile < 0L || this.controlFileRecord.minNeededLogFileOffset < 0L) {
            invalidControlFile = true;
        }
        if (this.controlFileRecord.minExistingLogFile > this.controlFileRecord.minNeededLogFile) {
            invalidControlFile = true;
        }
        if (magicNumber != -15597807) {
            invalidControlFile = true;
        }
        if (invalidControlFile) {
            throw new InvalidLogException(I18n.err(I18n.ERR_750, new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNextLogFile(boolean reformatExistingFile) throws IOException, InvalidLogException {
        LogFileManager.LogFileWriter writer = null;
        long logFileNumber = this.currentLogFileNumber;
        if (!reformatExistingFile) {
            ++logFileNumber;
        }
        boolean fileAlreadyExists = this.logFileManager.createLogFile(logFileNumber);
        if (!reformatExistingFile && fileAlreadyExists) {
            throw new InvalidLogException(I18n.err(I18n.ERR_750, new Object[0]));
        }
        if (reformatExistingFile && !fileAlreadyExists) {
            throw new InvalidLogException(I18n.err(I18n.ERR_750, new Object[0]));
        }
        if (reformatExistingFile) {
            this.logFileManager.truncateLogFile(logFileNumber, 0L);
        }
        writer = this.logFileManager.getWriterForLogFile(logFileNumber);
        try {
            this.markerHead.rewind();
            this.markerHead.putLong(logFileNumber);
            this.markerHead.putInt(-16711936);
            writer.append(this.markerBuffer, 0, 12);
            writer.sync();
        }
        finally {
            writer.close();
        }
        this.currentLogFileNumber = logFileNumber;
    }

    private void deleteUnnecessaryLogFiles(long startingLogFileNumber, long endingLogFileNumber) {
        for (long logFileNumber = startingLogFileNumber; logFileNumber < endingLogFileNumber; ++logFileNumber) {
            try {
                this.logFileManager.deleteLogFile(logFileNumber);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private class ControlFileRecord {
        long minExistingLogFile;
        long minNeededLogFile;
        long minNeededLogFileOffset;
        long minNeededLSN;
        long checksum;

        private ControlFileRecord() {
        }
    }
}

