/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.shared;

import java.util.HashSet;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.DITContentRule;
import org.apache.directory.shared.ldap.model.schema.DITStructureRule;
import org.apache.directory.shared.ldap.model.schema.LdapComparator;
import org.apache.directory.shared.ldap.model.schema.LdapSyntax;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.model.schema.NameForm;
import org.apache.directory.shared.ldap.model.schema.Normalizer;
import org.apache.directory.shared.ldap.model.schema.ObjectClass;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.SchemaUtils;
import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.model.schema.registries.NormalizerRegistry;
import org.apache.directory.shared.util.StringConstants;

public class SchemaService {
    private static Entry schemaSubentry;
    private static Object schemaSubentrLock;

    private static Attribute generateComparators(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.lookupAttributeTypeRegistry("comparators"));
        for (LdapComparator comparator : schemaManager.getComparatorRegistry()) {
            attr.add(SchemaUtils.render(comparator));
        }
        return attr;
    }

    private static Attribute generateNormalizers(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("normalizers"));
        NormalizerRegistry nr = schemaManager.getNormalizerRegistry();
        for (Normalizer normalizer : nr) {
            attr.add(SchemaUtils.render(normalizer));
        }
        return attr;
    }

    private static Attribute generateSyntaxCheckers(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("syntaxCheckers"));
        for (SyntaxChecker syntaxChecker : schemaManager.getSyntaxCheckerRegistry()) {
            attr.add(SchemaUtils.render(syntaxChecker));
        }
        return attr;
    }

    private static Attribute generateObjectClasses(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("objectClasses"));
        for (ObjectClass objectClass : schemaManager.getObjectClassRegistry()) {
            attr.add(SchemaUtils.render(objectClass).toString());
        }
        return attr;
    }

    private static Attribute generateAttributeTypes(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("attributeTypes"));
        for (AttributeType attributeType : schemaManager.getAttributeTypeRegistry()) {
            attr.add(SchemaUtils.render(attributeType).toString());
        }
        return attr;
    }

    private static Attribute generateMatchingRules(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("matchingRules"));
        for (MatchingRule matchingRule : schemaManager.getMatchingRuleRegistry()) {
            attr.add(SchemaUtils.render(matchingRule).toString());
        }
        return attr;
    }

    private static Attribute generateMatchingRuleUses(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("matchingRuleUse"));
        for (MatchingRuleUse matchingRuleUse : schemaManager.getMatchingRuleUseRegistry()) {
            attr.add(SchemaUtils.render(matchingRuleUse).toString());
        }
        return attr;
    }

    private static Attribute generateSyntaxes(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("ldapSyntaxes"));
        for (LdapSyntax syntax : schemaManager.getLdapSyntaxRegistry()) {
            attr.add(SchemaUtils.render(syntax).toString());
        }
        return attr;
    }

    private static Attribute generateDitContextRules(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("ditContentRules"));
        for (DITContentRule ditContentRule : schemaManager.getDITContentRuleRegistry()) {
            attr.add(SchemaUtils.render(ditContentRule).toString());
        }
        return attr;
    }

    private static Attribute generateDitStructureRules(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("ditStructureRules"));
        for (DITStructureRule ditStructureRule : schemaManager.getDITStructureRuleRegistry()) {
            attr.add(SchemaUtils.render(ditStructureRule).toString());
        }
        return attr;
    }

    private static Attribute generateNameForms(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("nameForms"));
        for (NameForm nameForm : schemaManager.getNameFormRegistry()) {
            attr.add(SchemaUtils.render(nameForm).toString());
        }
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateSchemaSubentry(SchemaManager schemaManager, Entry mods) throws LdapException {
        DefaultEntry attrs = new DefaultEntry(schemaManager, mods.getDn());
        attrs.put("objectClass", "top", "subschema", "subentry", "apacheSubschema");
        attrs.put("cn", "schema");
        attrs.put(SchemaService.generateComparators(schemaManager));
        attrs.put(SchemaService.generateNormalizers(schemaManager));
        attrs.put(SchemaService.generateSyntaxCheckers(schemaManager));
        attrs.put(SchemaService.generateObjectClasses(schemaManager));
        attrs.put(SchemaService.generateAttributeTypes(schemaManager));
        attrs.put(SchemaService.generateMatchingRules(schemaManager));
        attrs.put(SchemaService.generateMatchingRuleUses(schemaManager));
        attrs.put(SchemaService.generateSyntaxes(schemaManager));
        attrs.put(SchemaService.generateDitContextRules(schemaManager));
        attrs.put(SchemaService.generateDitStructureRules(schemaManager));
        attrs.put(SchemaService.generateNameForms(schemaManager));
        attrs.put("subtreeSpecification", "{}");
        Attribute createTimestamp = mods.get("createTimestamp");
        attrs.put("createTimestamp", createTimestamp.get());
        attrs.put("creatorsName", "uid=admin,ou=system");
        Attribute schemaModifyTimestamp = mods.get("schemaModifyTimestamp");
        attrs.put("modifyTimestamp", schemaModifyTimestamp.get());
        Attribute schemaModifiersName = mods.get("schemaModifiersName");
        attrs.put("modifiersName", schemaModifiersName.get());
        Object object = schemaSubentrLock;
        synchronized (object) {
            schemaSubentry = attrs;
        }
    }

    private static void addAttribute(Entry attrs, String id) throws LdapException {
        Attribute attr = schemaSubentry.get(id);
        if (attr != null) {
            attrs.put(attr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Entry getSubschemaEntryImmutable(DirectoryService directoryService) throws LdapException {
        Object object = schemaSubentrLock;
        synchronized (object) {
            if (schemaSubentry == null) {
                Dn schemaModificationAttributesDn = new Dn(directoryService.getSchemaManager(), "ou=schemaModifications,ou=schema");
                SchemaService.generateSchemaSubentry(directoryService.getSchemaManager(), directoryService.getSchemaPartition().lookup(new LookupOperationContext(null, schemaModificationAttributesDn)));
            }
            return schemaSubentry.clone();
        }
    }

    public static Entry getSubschemaEntryCloned(DirectoryService directoryService) throws LdapException {
        if (schemaSubentry == null) {
            Dn schemaModificationAttributesDn = new Dn(directoryService.getSchemaManager(), "ou=schemaModifications,ou=schema");
            SchemaService.generateSchemaSubentry(directoryService.getSchemaManager(), directoryService.getSchemaPartition().lookup(new LookupOperationContext(null, schemaModificationAttributesDn)));
        }
        return schemaSubentry.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Entry getSubschemaEntry(DirectoryService directoryService, String[] ids) throws LdapException {
        if (ids == null) {
            ids = StringConstants.EMPTY_STRINGS;
        }
        SchemaManager schemaManager = directoryService.getSchemaManager();
        HashSet<String> setOids = new HashSet<String>();
        DefaultEntry attrs = new DefaultEntry(schemaManager, Dn.ROOT_DSE);
        boolean returnAllOperationalAttributes = false;
        Object object = schemaSubentrLock;
        synchronized (object) {
            Dn schemaModificationAttributesDn = new Dn(directoryService.getSchemaManager(), "ou=schemaModifications,ou=schema");
            Entry mods = directoryService.getSchemaPartition().lookup(new LookupOperationContext(null, schemaModificationAttributesDn, SchemaConstants.ALL_ATTRIBUTES_ARRAY));
            SchemaService.generateSchemaSubentry(schemaManager, mods);
            for (String id : ids) {
                if ("+".equals(id)) {
                    returnAllOperationalAttributes = true;
                    continue;
                }
                if ("*".equals(id)) {
                    setOids.add(id);
                    continue;
                }
                setOids.add(schemaManager.getAttributeTypeRegistry().getOidByName(id));
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.32")) {
                SchemaService.addAttribute(attrs, "comparators");
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.33")) {
                SchemaService.addAttribute(attrs, "normalizers");
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.34")) {
                SchemaService.addAttribute(attrs, "syntaxCheckers");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.6")) {
                SchemaService.addAttribute(attrs, "objectClasses");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.5")) {
                SchemaService.addAttribute(attrs, "attributeTypes");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.4")) {
                SchemaService.addAttribute(attrs, "matchingRules");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.8")) {
                SchemaService.addAttribute(attrs, "matchingRuleUse");
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.1466.101.120.16")) {
                SchemaService.addAttribute(attrs, "ldapSyntaxes");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.2")) {
                SchemaService.addAttribute(attrs, "ditContentRules");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.1")) {
                SchemaService.addAttribute(attrs, "ditStructureRules");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.7")) {
                SchemaService.addAttribute(attrs, "nameForms");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.6")) {
                SchemaService.addAttribute(attrs, "subtreeSpecification");
            }
            int minSetSize = 0;
            if (setOids.contains("+")) {
                ++minSetSize;
            }
            if (setOids.contains("*")) {
                ++minSetSize;
            }
            if (setOids.contains("2.16.840.1.113730.3.1.34")) {
                ++minSetSize;
            }
            if (setOids.contains("*") || setOids.contains("2.5.4.0") || setOids.size() == minSetSize) {
                SchemaService.addAttribute(attrs, "objectClass");
            }
            if (setOids.contains("*") || setOids.contains("2.5.4.3") || setOids.size() == minSetSize) {
                SchemaService.addAttribute(attrs, "cn");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.1")) {
                SchemaService.addAttribute(attrs, "createTimestamp");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.3")) {
                SchemaService.addAttribute(attrs, "creatorsName");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.2")) {
                SchemaService.addAttribute(attrs, "modifyTimestamp");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.4")) {
                SchemaService.addAttribute(attrs, "modifiersName");
            }
        }
        return attrs;
    }

    static {
        schemaSubentrLock = new Object();
    }
}

